/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.event;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import me.lucko.luckperms.common.event.AbstractEventBus;
import me.lucko.luckperms.lib.eventbus.EventSubscriber;
import net.luckperms.api.event.EventSubscription;
import net.luckperms.api.event.LuckPermsEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LuckPermsEventSubscription<T extends LuckPermsEvent>
implements EventSubscription<T>,
EventSubscriber<T> {
    private final AbstractEventBus<?> eventBus;
    private final Class<T> eventClass;
    private final Consumer<? super T> consumer;
    private final @Nullable Object plugin;
    private final AtomicBoolean active = new AtomicBoolean(true);

    public LuckPermsEventSubscription(AbstractEventBus<?> eventBus, Class<T> eventClass, Consumer<? super T> consumer, @Nullable Object plugin) {
        this.eventBus = eventBus;
        this.eventClass = eventClass;
        this.consumer = consumer;
        this.plugin = plugin;
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }

    @Override
    public void close() {
        if (!this.active.getAndSet(false)) {
            return;
        }
        this.eventBus.unregisterHandler(this);
    }

    public void invoke(@NonNull T event) throws Throwable {
        try {
            this.consumer.accept(event);
        }
        catch (Throwable t) {
            this.eventBus.getPlugin().getLogger().warn("Unable to pass event " + event.getEventType().getSimpleName() + " to handler " + this.consumer.getClass().getName());
            t.printStackTrace();
        }
    }

    @Override
    public @NonNull Class<T> getEventClass() {
        return this.eventClass;
    }

    @Override
    public @NonNull Consumer<? super T> getHandler() {
        return this.consumer;
    }

    public @Nullable Object getPlugin() {
        return this.plugin;
    }
}

