/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging.redis;

import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.lib.commonspool2.impl.GenericObjectPoolConfig;
import me.lucko.luckperms.lib.jedis.Jedis;
import me.lucko.luckperms.lib.jedis.JedisPool;
import me.lucko.luckperms.lib.jedis.JedisPoolConfig;
import me.lucko.luckperms.lib.jedis.JedisPubSub;
import net.luckperms.api.messenger.IncomingMessageConsumer;
import net.luckperms.api.messenger.Messenger;
import net.luckperms.api.messenger.message.OutgoingMessage;
import org.checkerframework.checker.nullness.qual.NonNull;

public class RedisMessenger
implements Messenger {
    private static final String CHANNEL = "luckperms:update";
    private final LuckPermsPlugin plugin;
    private final IncomingMessageConsumer consumer;
    private JedisPool jedisPool;
    private Subscription sub;

    public RedisMessenger(LuckPermsPlugin plugin, IncomingMessageConsumer consumer) {
        this.plugin = plugin;
        this.consumer = consumer;
    }

    public void init(String address, String password, boolean ssl) {
        String[] addressSplit = address.split(":");
        String host = addressSplit[0];
        int port = addressSplit.length > 1 ? Integer.parseInt(addressSplit[1]) : 6379;
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), host, port, 2000, password, ssl);
        this.plugin.getBootstrap().getScheduler().executeAsync(() -> {
            this.sub = new Subscription(this);
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.subscribe((JedisPubSub)this.sub, new String[]{CHANNEL});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void sendOutgoingMessage(@NonNull OutgoingMessage outgoingMessage) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.publish(CHANNEL, outgoingMessage.asEncodedString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        this.sub.unsubscribe();
        this.jedisPool.destroy();
    }

    private static class Subscription
    extends JedisPubSub {
        private final RedisMessenger parent;

        private Subscription(RedisMessenger parent) {
            this.parent = parent;
        }

        public void onMessage(String channel, String msg) {
            if (!channel.equals(RedisMessenger.CHANNEL)) {
                return;
            }
            this.parent.consumer.consumeIncomingMessageAsString(msg);
        }
    }
}

