/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.metastacking;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.metastacking.MetaStack;
import me.lucko.luckperms.common.metastacking.MetaStackEntry;
import me.lucko.luckperms.common.metastacking.SimpleMetaStackEntry;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.metastacking.MetaStackElement;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.types.ChatMetaNode;

public final class SimpleMetaStack
implements MetaStack {
    private final MetaStackDefinition definition;
    private final ChatMetaType targetType;
    private final List<MetaStackEntry> entries;

    public SimpleMetaStack(MetaStackDefinition definition, ChatMetaType targetType) {
        this.definition = definition;
        this.targetType = targetType;
        this.entries = (List)definition.getElements().stream().map(element -> new SimpleMetaStackEntry(this, (MetaStackElement)element, targetType)).collect(ImmutableCollectors.toList());
    }

    @Override
    public String toFormattedString() {
        List elements = this.entries.stream().map(MetaStackEntry::getCurrentValue).filter(Optional::isPresent).map(Optional::get).map(ChatMetaNode::getMetaValue).collect(Collectors.toCollection(LinkedList::new));
        if (elements.isEmpty()) {
            return null;
        }
        this.definition.getDuplicateRemovalFunction().processDuplicates(elements);
        StringBuilder sb = new StringBuilder();
        sb.append(this.definition.getStartSpacer());
        for (int i = 0; i < elements.size(); ++i) {
            if (i != 0) {
                sb.append(this.definition.getMiddleSpacer());
            }
            sb.append((String)elements.get(i));
        }
        sb.append(this.definition.getEndSpacer());
        return sb.toString();
    }

    @Override
    public void accumulateToAll(ChatMetaNode<?, ?> node) {
        this.entries.forEach(e -> e.accumulateNode(node));
    }

    @Override
    public MetaStackDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public ChatMetaType getTargetType() {
        return this.targetType;
    }
}

