/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.metastacking;

import java.util.Optional;
import me.lucko.luckperms.common.metastacking.MetaStack;
import me.lucko.luckperms.common.metastacking.MetaStackEntry;
import net.luckperms.api.metastacking.MetaStackElement;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.types.ChatMetaNode;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SimpleMetaStackEntry
implements MetaStackEntry {
    private final MetaStack parentStack;
    private final MetaStackElement element;
    private final ChatMetaType type;
    private @Nullable ChatMetaNode<?, ?> current = null;

    public SimpleMetaStackEntry(MetaStack parentStack, MetaStackElement element, ChatMetaType type) {
        this.parentStack = parentStack;
        this.element = element;
        this.type = type;
    }

    @Override
    public Optional<ChatMetaNode<?, ?>> getCurrentValue() {
        return Optional.ofNullable(this.current);
    }

    @Override
    public boolean accumulateNode(ChatMetaNode<?, ?> node) {
        if (this.element.shouldAccumulate(this.type, node, this.current)) {
            this.current = node;
            return true;
        }
        return false;
    }

    @Override
    public MetaStack getParentStack() {
        return this.parentStack;
    }

    @Override
    public MetaStackElement getElement() {
        return this.element;
    }

    public ChatMetaType getType() {
        return this.type;
    }
}

