/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Optional;
import java.util.OptionalInt;
import me.lucko.luckperms.common.api.implementation.ApiGroup;
import me.lucko.luckperms.common.cache.Cache;
import me.lucko.luckperms.common.cacheddata.GroupCachedDataManager;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.WeightCache;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.DisplayNameNode;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Group
extends PermissionHolder {
    private final ApiGroup apiProxy = new ApiGroup(this);
    private final String name;
    private final Cache<OptionalInt> weightCache = new WeightCache(this);
    private final Cache<Optional<String>> displayNameCache = new DisplayNameCache();
    private final GroupCachedDataManager cachedData;

    public Group(String name, LuckPermsPlugin plugin) {
        super(plugin);
        this.name = name.toLowerCase();
        this.cachedData = new GroupCachedDataManager(this);
        this.getPlugin().getEventDispatcher().dispatchGroupCacheLoad(this, this.cachedData);
    }

    @Override
    protected void invalidateCache() {
        super.invalidateCache();
        this.weightCache.invalidate();
        this.displayNameCache.invalidate();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    public ApiGroup getApiProxy() {
        return this.apiProxy;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.getPlugin().getContextManager().getStaticQueryOptions();
    }

    public GroupCachedDataManager getCachedData() {
        return this.cachedData;
    }

    @Override
    public String getFormattedDisplayName() {
        return this.getDisplayName().map(s -> this.name + " &r(" + s + "&r)").orElse(this.name);
    }

    @Override
    public String getPlainDisplayName() {
        return this.getDisplayName().orElse(this.getName());
    }

    public Optional<String> getDisplayName() {
        return this.displayNameCache.get();
    }

    public Optional<String> calculateDisplayName(QueryOptions queryOptions) {
        for (Node n : this.getOwnNodes(queryOptions)) {
            if (!(n instanceof DisplayNameNode)) continue;
            DisplayNameNode displayNameNode = (DisplayNameNode)n;
            return Optional.of(displayNameNode.getDisplayName());
        }
        String name = this.getPlugin().getConfiguration().get(ConfigKeys.GROUP_NAME_REWRITES).get(this.name);
        return name == null || name.equals(this.name) ? Optional.empty() : Optional.of(name);
    }

    @Override
    public OptionalInt getWeight() {
        return this.weightCache.get();
    }

    @Override
    public HolderType getType() {
        return HolderType.GROUP;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)o;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Group(name=" + this.name + ")";
    }

    public class DisplayNameCache
    extends Cache<Optional<String>> {
        @Override
        protected @NonNull Optional<String> supply() {
            return Group.this.calculateDisplayName(Group.this.getPlugin().getContextManager().getStaticQueryOptions());
        }
    }
}

