/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.lucko.luckperms.common.cache.Cache;
import me.lucko.luckperms.common.context.ContextSetComparator;
import me.lucko.luckperms.common.model.InheritanceOrigin;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.comparator.NodeComparator;
import me.lucko.luckperms.common.node.comparator.NodeWithContextComparator;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.metadata.types.InheritanceOriginMetadata;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.query.Flag;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NodeMap {
    private static final Function<ImmutableContextSet, SortedSet<Node>> VALUE_SET_SUPPLIER = k -> new ConcurrentSkipListSet<Node>(NodeComparator.reverse());
    private static final Function<ImmutableContextSet, SortedSet<InheritanceNode>> INHERITANCE_VALUE_SET_SUPPLIER = k -> new ConcurrentSkipListSet<Node>(NodeComparator.reverse());
    private final PermissionHolder holder;
    private final SortedMap<ImmutableContextSet, SortedSet<Node>> map = new ConcurrentSkipListMap<ImmutableContextSet, SortedSet<Node>>(ContextSetComparator.reverse());
    private final SortedMap<ImmutableContextSet, SortedSet<InheritanceNode>> inheritanceMap = new ConcurrentSkipListMap<ImmutableContextSet, SortedSet<InheritanceNode>>(ContextSetComparator.reverse());
    private final ImmutableSetMultimapCache<ImmutableContextSet, Node> mapCache = new ImmutableSetMultimapCache(this.map);
    private final ImmutableSetMultimapCache<ImmutableContextSet, InheritanceNode> inheritanceMapCache = new ImmutableSetMultimapCache(this.inheritanceMap);

    NodeMap(PermissionHolder holder) {
        this.holder = holder;
    }

    public LinkedHashSet<Node> asSet() {
        LinkedHashSet<Node> set = new LinkedHashSet<Node>();
        this.copyTo(set, QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL);
        return set;
    }

    public SortedSet<Node> asSortedSet() {
        TreeSet<Node> set = new TreeSet<Node>(NodeWithContextComparator.reverse());
        this.copyTo(set, QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL);
        return set;
    }

    public LinkedHashSet<InheritanceNode> inheritanceAsSet() {
        LinkedHashSet<InheritanceNode> set = new LinkedHashSet<InheritanceNode>();
        this.copyInheritanceNodesTo(set, QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL);
        return set;
    }

    public SortedSet<InheritanceNode> inheritanceAsSortedSet() {
        TreeSet<? super Node> set = new TreeSet<Node>(NodeWithContextComparator.reverse());
        this.copyInheritanceNodesTo(set, QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL);
        return set;
    }

    private static boolean flagExcludeTest(Flag flag, String contextKey, QueryOptions filter, ImmutableContextSet contextSet) {
        return !filter.flag(flag) && !contextSet.containsKey(contextKey);
    }

    private static boolean normalNodesExcludeTest(QueryOptions filter, ImmutableContextSet contextSet) {
        return NodeMap.flagExcludeTest(Flag.INCLUDE_NODES_WITHOUT_SERVER_CONTEXT, "server", filter, contextSet) || NodeMap.flagExcludeTest(Flag.INCLUDE_NODES_WITHOUT_WORLD_CONTEXT, "world", filter, contextSet);
    }

    private static boolean inheritanceNodesIncludeTest(QueryOptions filter, ImmutableContextSet contextSet) {
        return !NodeMap.flagExcludeTest(Flag.APPLY_INHERITANCE_NODES_WITHOUT_SERVER_CONTEXT, "server", filter, contextSet) && !NodeMap.flagExcludeTest(Flag.APPLY_INHERITANCE_NODES_WITHOUT_WORLD_CONTEXT, "world", filter, contextSet);
    }

    public void forEach(QueryOptions filter, Consumer<? super Node> consumer) {
        for (Map.Entry<ImmutableContextSet, SortedSet<Node>> e : this.map.entrySet()) {
            if (!filter.satisfies(e.getKey())) continue;
            if (NodeMap.normalNodesExcludeTest(filter, e.getKey())) {
                SortedSet inheritanceNodes;
                if (!NodeMap.inheritanceNodesIncludeTest(filter, e.getKey()) || (inheritanceNodes = (SortedSet)this.inheritanceMap.get(e.getKey())) == null) continue;
                inheritanceNodes.forEach(consumer);
                continue;
            }
            e.getValue().forEach(consumer);
        }
    }

    public void copyTo(Collection<? super Node> collection, QueryOptions filter) {
        for (Map.Entry<ImmutableContextSet, SortedSet<Node>> e : this.map.entrySet()) {
            if (!filter.satisfies(e.getKey())) continue;
            if (NodeMap.normalNodesExcludeTest(filter, e.getKey())) {
                SortedSet inheritanceNodes;
                if (!NodeMap.inheritanceNodesIncludeTest(filter, e.getKey()) || (inheritanceNodes = (SortedSet)this.inheritanceMap.get(e.getKey())) == null) continue;
                collection.addAll(inheritanceNodes);
                continue;
            }
            collection.addAll((Collection<? super Node>)e.getValue());
        }
    }

    public <T extends Node> void copyTo(Collection<? super T> collection, NodeType<T> type, QueryOptions filter) {
        for (Map.Entry<ImmutableContextSet, SortedSet<Node>> e : this.map.entrySet()) {
            if (!filter.satisfies(e.getKey())) continue;
            if (NodeMap.normalNodesExcludeTest(filter, e.getKey())) {
                SortedSet inheritanceNodes;
                if (!NodeMap.inheritanceNodesIncludeTest(filter, e.getKey()) || type != NodeType.INHERITANCE || (inheritanceNodes = (SortedSet)this.inheritanceMap.get(e.getKey())) == null) continue;
                for (InheritanceNode node : inheritanceNodes) {
                    collection.add(type.cast(node));
                }
                continue;
            }
            for (Node node : e.getValue()) {
                if (!type.matches(node)) continue;
                collection.add(type.cast(node));
            }
        }
    }

    public void copyInheritanceNodesTo(Collection<? super InheritanceNode> collection, QueryOptions filter) {
        for (Map.Entry<ImmutableContextSet, SortedSet<InheritanceNode>> e : this.inheritanceMap.entrySet()) {
            if (!filter.satisfies(e.getKey()) || !NodeMap.inheritanceNodesIncludeTest(filter, e.getKey())) continue;
            collection.addAll((Collection<? super InheritanceNode>)e.getValue());
        }
    }

    public ImmutableSetMultimap<ImmutableContextSet, Node> immutable() {
        return (ImmutableSetMultimap)this.mapCache.get();
    }

    public ImmutableSetMultimap<ImmutableContextSet, InheritanceNode> immutableInheritance() {
        return (ImmutableSetMultimap)this.inheritanceMapCache.get();
    }

    void invalidate() {
        this.mapCache.invalidate();
        this.inheritanceMapCache.invalidate();
    }

    private Node localise(Node node) {
        Optional<InheritanceOriginMetadata> metadata = node.getMetadata(InheritanceOriginMetadata.KEY);
        if (metadata.isPresent() && metadata.get().getOrigin().equals(this.holder.getIdentifier())) {
            return node;
        }
        return node.toBuilder().withMetadata(InheritanceOriginMetadata.KEY, new InheritanceOrigin(this.holder.getIdentifier())).build();
    }

    void add(Node node) {
        ImmutableContextSet context = node.getContexts();
        Node n = this.localise(node);
        SortedSet<Node> nodesInContext = this.map.computeIfAbsent(context, VALUE_SET_SUPPLIER);
        nodesInContext.removeIf((? super E e) -> e.equals(node, NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE));
        nodesInContext.add(n);
        if (n instanceof InheritanceNode) {
            SortedSet<InheritanceNode> inheritanceNodesInContext = this.inheritanceMap.computeIfAbsent(context, INHERITANCE_VALUE_SET_SUPPLIER);
            inheritanceNodesInContext.removeIf((? super E e) -> e.equals(node, NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE));
            if (n.getValue()) {
                inheritanceNodesInContext.add((InheritanceNode)n);
            }
        }
    }

    void remove(Node node) {
        SortedSet inheritanceNodesInContext;
        ImmutableContextSet context = node.getContexts();
        SortedSet nodesInContext = (SortedSet)this.map.get(context);
        if (nodesInContext != null) {
            nodesInContext.removeIf((? super E e) -> e.equals(node, NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE));
        }
        if (node instanceof InheritanceNode && (inheritanceNodesInContext = (SortedSet)this.inheritanceMap.get(context)) != null) {
            inheritanceNodesInContext.removeIf((? super E e) -> e.equals(node, NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE));
        }
    }

    private void removeExact(Node node) {
        SortedSet inheritanceNodesInContext;
        ImmutableContextSet context = node.getContexts();
        SortedSet nodesInContext = (SortedSet)this.map.get(context);
        if (nodesInContext != null) {
            nodesInContext.remove(node);
        }
        if (node instanceof InheritanceNode && node.getValue() && (inheritanceNodesInContext = (SortedSet)this.inheritanceMap.get(context)) != null) {
            inheritanceNodesInContext.remove(node);
        }
    }

    void replace(Node node, Node previous) {
        this.removeExact(previous);
        this.add(node);
    }

    void clear() {
        this.map.clear();
        this.inheritanceMap.clear();
    }

    void clear(ContextSet contextSet) {
        ImmutableContextSet context = contextSet.immutableCopy();
        this.map.remove(context);
        this.inheritanceMap.remove(context);
    }

    void setContent(Iterable<? extends Node> set) {
        this.map.clear();
        this.inheritanceMap.clear();
        for (Node node : set) {
            this.add(node);
        }
    }

    void setContent(Stream<? extends Node> stream) {
        this.map.clear();
        this.inheritanceMap.clear();
        stream.forEach(this::add);
    }

    void setContent(Multimap<ImmutableContextSet, ? extends Node> multimap) {
        this.setContent(multimap.values());
    }

    boolean removeIf(Predicate<? super Node> predicate) {
        boolean success = false;
        for (SortedSet<Node> sortedSet : this.map.values()) {
            if (!sortedSet.removeIf(predicate)) continue;
            success = true;
        }
        for (SortedSet<Node> sortedSet : this.inheritanceMap.values()) {
            sortedSet.removeIf(predicate);
        }
        return success;
    }

    boolean removeIf(ContextSet contextSet, Predicate<? super Node> predicate) {
        SortedSet inheritanceNodesInContext;
        ImmutableContextSet context = contextSet.immutableCopy();
        boolean success = false;
        SortedSet nodesInContext = (SortedSet)this.map.get(context);
        if (nodesInContext != null) {
            success = nodesInContext.removeIf(predicate);
        }
        if ((inheritanceNodesInContext = (SortedSet)this.inheritanceMap.get(context)) != null) {
            inheritanceNodesInContext.removeIf(predicate);
        }
        return success;
    }

    boolean auditTemporaryNodes(@Nullable Set<? super Node> removed) {
        boolean work = false;
        for (SortedSet<Node> valueSet : this.map.values()) {
            Iterator it = valueSet.iterator();
            while (it.hasNext()) {
                SortedSet inheritanceNodesInContext;
                Node entry = (Node)it.next();
                if (!entry.hasExpired()) continue;
                if (removed != null) {
                    removed.add(entry);
                }
                if (entry instanceof InheritanceNode && entry.getValue() && (inheritanceNodesInContext = (SortedSet)this.inheritanceMap.get(entry.getContexts())) != null) {
                    inheritanceNodesInContext.remove(entry);
                }
                it.remove();
                work = true;
            }
        }
        return work;
    }

    private static final class ImmutableSetMultimapCache<K, V>
    extends Cache<ImmutableSetMultimap<K, V>> {
        private static final Constructor<ImmutableSetMultimap> IMMUTABLE_SET_MULTIMAP_CONSTRUCTOR;
        private final Map<K, ? extends Collection<V>> handle;

        private ImmutableSetMultimapCache(Map<K, ? extends Collection<V>> handle) {
            this.handle = handle;
        }

        @Override
        protected @NonNull ImmutableSetMultimap<K, V> supply() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int size = 0;
            for (Map.Entry<K, Collection<V>> entry : this.handle.entrySet()) {
                K key = entry.getKey();
                ImmutableSet values = ImmutableSet.copyOf(entry.getValue());
                if (values.isEmpty()) continue;
                builder.put(key, (Object)values);
                size += values.size();
            }
            try {
                return IMMUTABLE_SET_MULTIMAP_CONSTRUCTOR.newInstance(builder.build(), size, null);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            try {
                IMMUTABLE_SET_MULTIMAP_CONSTRUCTOR = ImmutableSetMultimap.class.getDeclaredConstructor(ImmutableMap.class, Integer.TYPE, Comparator.class);
                IMMUTABLE_SET_MULTIMAP_CONSTRUCTOR.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

