/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.lucko.luckperms.common.cacheddata.HolderCachedDataManager;
import me.lucko.luckperms.common.cacheddata.type.MetaAccumulator;
import me.lucko.luckperms.common.inheritance.InheritanceComparator;
import me.lucko.luckperms.common.inheritance.InheritanceGraph;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.NodeMap;
import me.lucko.luckperms.common.model.PermissionHolderIdentifier;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.comparator.NodeWithContextComparator;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.model.data.TemporaryNodeMergeStrategy;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.query.Flag;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.query.dataorder.DataQueryOrder;
import net.luckperms.api.query.dataorder.DataQueryOrderFunction;
import net.luckperms.api.util.Tristate;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PermissionHolder {
    private final LuckPermsPlugin plugin;
    private @MonotonicNonNull PermissionHolderIdentifier identifier;
    private final NodeMap normalNodes = new NodeMap(this);
    private final NodeMap transientNodes = new NodeMap(this);
    private final Lock ioLock = new ReentrantLock();
    private final Comparator<? super PermissionHolder> inheritanceComparator = InheritanceComparator.getFor(this);

    protected PermissionHolder(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    public Lock getIoLock() {
        return this.ioLock;
    }

    public Comparator<? super PermissionHolder> getInheritanceComparator() {
        return this.inheritanceComparator;
    }

    public NodeMap getData(DataType type) {
        switch (type) {
            case NORMAL: {
                return this.normalNodes;
            }
            case TRANSIENT: {
                return this.transientNodes;
            }
        }
        throw new AssertionError();
    }

    public NodeMap normalData() {
        return this.normalNodes;
    }

    public NodeMap transientData() {
        return this.transientNodes;
    }

    public PermissionHolderIdentifier getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new PermissionHolderIdentifier(this.getType(), this.getObjectName());
        }
        return this.identifier;
    }

    public abstract String getObjectName();

    public abstract String getFormattedDisplayName();

    public abstract String getPlainDisplayName();

    public abstract QueryOptions getQueryOptions();

    public abstract HolderCachedDataManager<?> getCachedData();

    public abstract HolderType getType();

    protected void invalidateCache() {
        this.normalNodes.invalidate();
        this.transientNodes.invalidate();
        this.getCachedData().invalidate();
        this.getPlugin().getEventDispatcher().dispatchDataRecalculate(this);
    }

    public void setNodes(DataType type, Iterable<? extends Node> set) {
        this.getData(type).setContent(set);
        this.invalidateCache();
    }

    public void setNodes(DataType type, Stream<? extends Node> stream) {
        this.getData(type).setContent(stream);
        this.invalidateCache();
    }

    public void replaceNodes(DataType type, Multimap<ImmutableContextSet, ? extends Node> multimap) {
        this.getData(type).setContent(multimap);
        this.invalidateCache();
    }

    private List<DataType> queryOrder(QueryOptions queryOptions) {
        Comparator comparator = queryOptions.option(DataQueryOrderFunction.KEY).map(func -> func.getOrderComparator(this.getIdentifier())).orElse(DataQueryOrder.TRANSIENT_FIRST);
        return DataQueryOrder.order(comparator);
    }

    public List<Node> getOwnNodes(QueryOptions queryOptions) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (DataType dataType : this.queryOrder(queryOptions)) {
            this.getData(dataType).copyTo(nodes, queryOptions);
        }
        return nodes;
    }

    public SortedSet<Node> getOwnNodesSorted(QueryOptions queryOptions) {
        TreeSet<Node> nodes = new TreeSet<Node>(NodeWithContextComparator.reverse());
        for (DataType dataType : this.queryOrder(queryOptions)) {
            this.getData(dataType).copyTo(nodes, queryOptions);
        }
        return nodes;
    }

    public List<InheritanceNode> getOwnInheritanceNodes(QueryOptions queryOptions) {
        ArrayList<InheritanceNode> nodes = new ArrayList<InheritanceNode>();
        for (DataType dataType : this.queryOrder(queryOptions)) {
            this.getData(dataType).copyInheritanceNodesTo(nodes, queryOptions);
        }
        return nodes;
    }

    public <T extends Node> List<T> getOwnNodes(NodeType<T> type, QueryOptions queryOptions) {
        ArrayList nodes = new ArrayList();
        for (DataType dataType : this.queryOrder(queryOptions)) {
            this.getData(dataType).copyTo(nodes, type, queryOptions);
        }
        return nodes;
    }

    public List<Node> resolveInheritedNodes(QueryOptions queryOptions) {
        if (!queryOptions.flag(Flag.RESOLVE_INHERITANCE)) {
            return this.getOwnNodes(queryOptions);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        InheritanceGraph graph = this.plugin.getInheritanceGraphFactory().getGraph(queryOptions);
        for (PermissionHolder holder : graph.traverse(this)) {
            for (DataType dataType : holder.queryOrder(queryOptions)) {
                holder.getData(dataType).copyTo(nodes, queryOptions);
            }
        }
        return nodes;
    }

    public SortedSet<Node> resolveInheritedNodesSorted(QueryOptions queryOptions) {
        if (!queryOptions.flag(Flag.RESOLVE_INHERITANCE)) {
            return this.getOwnNodesSorted(queryOptions);
        }
        TreeSet<Node> nodes = new TreeSet<Node>(NodeWithContextComparator.reverse());
        InheritanceGraph graph = this.plugin.getInheritanceGraphFactory().getGraph(queryOptions);
        for (PermissionHolder holder : graph.traverse(this)) {
            for (DataType dataType : holder.queryOrder(queryOptions)) {
                holder.getData(dataType).copyTo(nodes, queryOptions);
            }
        }
        return nodes;
    }

    public <T extends Node> List<T> resolveInheritedNodes(NodeType<T> type, QueryOptions queryOptions) {
        if (!queryOptions.flag(Flag.RESOLVE_INHERITANCE)) {
            return this.getOwnNodes(type, queryOptions);
        }
        ArrayList nodes = new ArrayList();
        InheritanceGraph graph = this.plugin.getInheritanceGraphFactory().getGraph(queryOptions);
        for (PermissionHolder holder : graph.traverse(this)) {
            for (DataType dataType : holder.queryOrder(queryOptions)) {
                holder.getData(dataType).copyTo(nodes, type, queryOptions);
            }
        }
        return nodes;
    }

    public List<Group> resolveInheritanceTree(QueryOptions queryOptions) {
        if (!queryOptions.flag(Flag.RESOLVE_INHERITANCE)) {
            return Collections.emptyList();
        }
        InheritanceGraph graph = this.plugin.getInheritanceGraphFactory().getGraph(queryOptions);
        ArrayList<Group> traversal = new ArrayList<Group>();
        Iterables.addAll(traversal, graph.traverse(this));
        if (traversal.get(0) == this) {
            traversal.remove(0);
        } else {
            traversal.remove(this);
        }
        for (PermissionHolder permissionHolder : traversal) {
            if (permissionHolder instanceof Group) continue;
            throw new IllegalStateException("Non-group object in inheritance tree: " + permissionHolder);
        }
        return traversal;
    }

    public Map<String, Boolean> exportPermissions(QueryOptions queryOptions, boolean convertToLowercase, boolean resolveShorthand) {
        List<Node> entries = this.resolveInheritedNodes(queryOptions);
        return PermissionHolder.processExportedPermissions(entries, convertToLowercase, resolveShorthand);
    }

    private static ImmutableMap<String, Boolean> processExportedPermissions(List<Node> entries, boolean convertToLowercase, boolean resolveShorthand) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(entries.size());
        for (Node node : entries) {
            if (convertToLowercase) {
                map.putIfAbsent(node.getKey().toLowerCase(), node.getValue());
                continue;
            }
            map.putIfAbsent(node.getKey(), node.getValue());
        }
        if (resolveShorthand) {
            for (Node node : entries) {
                Collection<String> shorthand = node.resolveShorthand();
                for (String s : shorthand) {
                    if (convertToLowercase) {
                        map.putIfAbsent(s.toLowerCase(), node.getValue());
                        continue;
                    }
                    map.putIfAbsent(s, node.getValue());
                }
            }
        }
        return ImmutableMap.copyOf(map);
    }

    public MetaAccumulator accumulateMeta(QueryOptions queryOptions) {
        return this.accumulateMeta(MetaAccumulator.makeFromConfig(this.plugin), queryOptions);
    }

    public MetaAccumulator accumulateMeta(MetaAccumulator accumulator, QueryOptions queryOptions) {
        InheritanceGraph graph = this.plugin.getInheritanceGraphFactory().getGraph(queryOptions);
        for (PermissionHolder holder : graph.traverse(this)) {
            for (DataType dataType : holder.queryOrder(queryOptions)) {
                holder.getData(dataType).forEach(queryOptions, node -> {
                    if (node.getValue() && NodeType.META_OR_CHAT_META.matches((Node)node)) {
                        accumulator.accumulateNode((Node)node);
                    }
                });
            }
            OptionalInt w = holder.getWeight();
            if (!w.isPresent()) continue;
            accumulator.accumulateWeight(w.getAsInt());
        }
        if (this instanceof User) {
            String primaryGroup = ((User)this).getPrimaryGroup().calculateValue(queryOptions);
            accumulator.setPrimaryGroup(primaryGroup);
        }
        accumulator.complete();
        return accumulator;
    }

    public boolean auditTemporaryNodes() {
        boolean transientWork = this.auditTemporaryNodes(DataType.TRANSIENT);
        boolean normalWork = this.auditTemporaryNodes(DataType.NORMAL);
        return transientWork || normalWork;
    }

    private boolean auditTemporaryNodes(DataType dataType) {
        ImmutableCollection before = this.getData(dataType).immutable().values();
        HashSet removed = new HashSet();
        boolean work = this.getData(dataType).auditTemporaryNodes(removed);
        if (work) {
            this.invalidateCache();
            ImmutableCollection after = this.getData(dataType).immutable().values();
            for (Node r : removed) {
                this.plugin.getEventDispatcher().dispatchNodeRemove(r, this, dataType, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
            }
        }
        return work;
    }

    public Tristate hasNode(DataType type, Node node, NodeEqualityPredicate equalityPredicate) {
        if (this.getType() == HolderType.GROUP && node instanceof InheritanceNode && ((InheritanceNode)node).getGroupName().equalsIgnoreCase(this.getObjectName())) {
            return Tristate.TRUE;
        }
        return this.getData(type).immutable().values().stream().filter(equalityPredicate.equalTo(node)).findFirst().map(n -> Tristate.of(n.getValue())).orElse(Tristate.UNDEFINED);
    }

    public DataMutateResult setNode(DataType dataType, Node node, boolean callEvent) {
        if (this.hasNode(dataType, node, NodeEqualityPredicate.IGNORE_EXPIRY_TIME) != Tristate.UNDEFINED) {
            return DataMutateResult.FAIL_ALREADY_HAS;
        }
        NodeMap data = this.getData(dataType);
        ImmutableCollection before = data.immutable().values();
        data.add(node);
        this.invalidateCache();
        ImmutableCollection after = data.immutable().values();
        if (callEvent) {
            this.plugin.getEventDispatcher().dispatchNodeAdd(node, this, dataType, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
        }
        return DataMutateResult.SUCCESS;
    }

    public DataMutateResult.WithMergedNode setNode(DataType dataType, Node node, TemporaryNodeMergeStrategy mergeStrategy) {
        Node otherMatch;
        if (node.getExpiry() != null && mergeStrategy != TemporaryNodeMergeStrategy.NONE && (otherMatch = (Node)this.getData(dataType).immutable().values().stream().filter(NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE.equalTo(node)).findFirst().orElse(null)) != null && otherMatch.getExpiry() != null) {
            NodeMap data = this.getData(dataType);
            Node newNode = null;
            switch (mergeStrategy) {
                case ADD_NEW_DURATION_TO_EXISTING: {
                    Instant newExpiry = otherMatch.getExpiry().plus(Duration.between(Instant.now(), node.getExpiry()));
                    newNode = node.toBuilder().expiry(newExpiry).build();
                    break;
                }
                case REPLACE_EXISTING_IF_DURATION_LONGER: {
                    if (node.getExpiry().compareTo(otherMatch.getExpiry()) <= 0) break;
                    newNode = node;
                }
            }
            if (newNode != null) {
                ImmutableCollection before = data.immutable().values();
                data.replace(newNode, otherMatch);
                this.invalidateCache();
                ImmutableCollection after = data.immutable().values();
                this.plugin.getEventDispatcher().dispatchNodeAdd(newNode, this, dataType, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
                return new MergedNodeResult(DataMutateResult.SUCCESS, newNode);
            }
        }
        return new MergedNodeResult(this.setNode(dataType, node, true), node);
    }

    public DataMutateResult unsetNode(DataType dataType, Node node) {
        if (this.hasNode(dataType, node, NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE) == Tristate.UNDEFINED) {
            return DataMutateResult.FAIL_LACKS;
        }
        ImmutableCollection before = this.getData(dataType).immutable().values();
        this.getData(dataType).remove(node);
        this.invalidateCache();
        ImmutableCollection after = this.getData(dataType).immutable().values();
        this.plugin.getEventDispatcher().dispatchNodeRemove(node, this, dataType, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
        return DataMutateResult.SUCCESS;
    }

    public boolean removeIf(DataType dataType, @Nullable ContextSet contextSet, Predicate<? super Node> predicate, boolean giveDefault) {
        NodeMap data = this.getData(dataType);
        ImmutableCollection before = data.immutable().values();
        if (contextSet == null ? !data.removeIf(predicate) : !data.removeIf(contextSet, predicate)) {
            return false;
        }
        if (this.getType() == HolderType.USER && giveDefault) {
            this.getPlugin().getUserManager().giveDefaultIfNeeded((User)this, false);
        }
        this.invalidateCache();
        ImmutableCollection after = data.immutable().values();
        this.plugin.getEventDispatcher().dispatchNodeClear(this, dataType, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
        return true;
    }

    public boolean clearNodes(DataType dataType, ContextSet contextSet, boolean giveDefault) {
        NodeMap data = this.getData(dataType);
        ImmutableCollection before = data.immutable().values();
        if (contextSet == null) {
            data.clear();
        } else {
            data.clear(contextSet);
        }
        if (this.getType() == HolderType.USER && giveDefault) {
            this.getPlugin().getUserManager().giveDefaultIfNeeded((User)this, false);
        }
        this.invalidateCache();
        ImmutableCollection after = data.immutable().values();
        if (before.size() == after.size()) {
            return false;
        }
        this.plugin.getEventDispatcher().dispatchNodeClear(this, dataType, (Collection<? extends Node>)before, (Collection<? extends Node>)after);
        return true;
    }

    public OptionalInt getWeight() {
        return OptionalInt.empty();
    }

    private static final class MergedNodeResult
    implements DataMutateResult.WithMergedNode {
        private final DataMutateResult result;
        private final Node mergedNode;

        private MergedNodeResult(DataMutateResult result, Node mergedNode) {
            this.result = result;
            this.mergedNode = mergedNode;
        }

        @Override
        public @NonNull DataMutateResult getResult() {
            return this.result;
        }

        @Override
        public @NonNull Node getMergedNode() {
            return this.mergedNode;
        }
    }
}

