/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Optional;
import java.util.UUID;
import me.lucko.luckperms.common.api.implementation.ApiUser;
import me.lucko.luckperms.common.cacheddata.UserCachedDataManager;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.PrimaryGroupHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class User
extends PermissionHolder {
    private final ApiUser apiProxy = new ApiUser(this);
    private final UUID uniqueId;
    private @Nullable String username = null;
    private final PrimaryGroupHolder primaryGroup;
    private final UserCachedDataManager cachedData;

    public User(UUID uniqueId, LuckPermsPlugin plugin) {
        super(plugin);
        this.uniqueId = uniqueId;
        this.primaryGroup = plugin.getConfiguration().get(ConfigKeys.PRIMARY_GROUP_CALCULATION).apply(this);
        this.cachedData = new UserCachedDataManager(this);
        this.getPlugin().getEventDispatcher().dispatchUserCacheLoad(this, this.cachedData);
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Override
    public String getObjectName() {
        return this.uniqueId.toString();
    }

    @Override
    public String getFormattedDisplayName() {
        return this.username != null ? this.username : this.uniqueId.toString();
    }

    @Override
    public String getPlainDisplayName() {
        return this.getFormattedDisplayName();
    }

    @Override
    public QueryOptions getQueryOptions() {
        QueryOptions queryOptions = this.getPlugin().getQueryOptionsForUser(this).orElse(null);
        if (queryOptions != null) {
            return queryOptions;
        }
        return this.getPlugin().getContextManager().getStaticQueryOptions();
    }

    public ApiUser getApiProxy() {
        return this.apiProxy;
    }

    public UserCachedDataManager getCachedData() {
        return this.cachedData;
    }

    public PrimaryGroupHolder getPrimaryGroup() {
        return this.primaryGroup;
    }

    public boolean setUsername(String name, boolean weak) {
        if (name != null && name.length() > 16) {
            return false;
        }
        if (weak && this.username != null) {
            if (this.username.equalsIgnoreCase(name)) {
                this.username = name;
            }
            return false;
        }
        if (name != null && (name.isEmpty() || name.equalsIgnoreCase("null"))) {
            name = null;
        }
        if (this.username == null != (name == null)) {
            this.username = name;
            return true;
        }
        if (this.username == null) {
            return false;
        }
        if (this.username.equalsIgnoreCase(name)) {
            this.username = name;
            return false;
        }
        this.username = name;
        return true;
    }

    @Override
    public HolderType getType() {
        return HolderType.USER;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        return this.uniqueId.equals(other.uniqueId);
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String toString() {
        return "User(uuid=" + this.uniqueId + ")";
    }
}

