/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Map;
import java.util.OptionalInt;
import me.lucko.luckperms.common.cache.Cache;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.WeightNode;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WeightCache
extends Cache<OptionalInt> {
    private final Group group;

    public WeightCache(Group group) {
        this.group = group;
    }

    @Override
    protected @NonNull OptionalInt supply() {
        Map<String, Integer> configWeights;
        Integer w;
        OptionalInt weight;
        boolean seen = false;
        int best = 0;
        for (Node n : this.group.getOwnNodes(QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL)) {
            if (!(n instanceof WeightNode)) continue;
            WeightNode weightNode = (WeightNode)n;
            int value = weightNode.getWeight();
            if (seen && value <= best) continue;
            seen = true;
            best = value;
        }
        OptionalInt optionalInt = weight = seen ? OptionalInt.of(best) : OptionalInt.empty();
        if (!weight.isPresent() && (w = (configWeights = this.group.getPlugin().getConfiguration().get(ConfigKeys.GROUP_WEIGHTS)).get(this.group.getObjectName().toLowerCase())) != null) {
            weight = OptionalInt.of(w);
        }
        return weight;
    }
}

