/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model.manager.user;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.model.manager.user.UserManager;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.util.ExpiringSet;

public class UserHousekeeper
implements Runnable {
    private final LuckPermsPlugin plugin;
    private final UserManager<?> userManager;
    private final ExpiringSet<UUID> recentlyUsed;
    private final ExpiringSet<UUID> recentlyUsedApi;

    public UserHousekeeper(LuckPermsPlugin plugin, UserManager<?> userManager, TimeoutSettings timeoutSettings) {
        this.plugin = plugin;
        this.userManager = userManager;
        this.recentlyUsed = new ExpiringSet(timeoutSettings.duration, timeoutSettings.unit);
        this.recentlyUsedApi = new ExpiringSet(5L, TimeUnit.MINUTES);
    }

    public void registerUsage(UUID uuid) {
        this.recentlyUsed.add(uuid);
    }

    public void registerApiUsage(UUID uuid) {
        this.recentlyUsedApi.add(uuid);
    }

    public void clearApiUsage(UUID uuid) {
        this.recentlyUsedApi.remove(uuid);
    }

    @Override
    public void run() {
        for (UUID entry : this.userManager.getAll().keySet()) {
            this.cleanup(entry);
        }
    }

    public void cleanup(UUID uuid) {
        if (this.recentlyUsed.contains(uuid) || this.recentlyUsedApi.contains(uuid) || this.plugin.getBootstrap().isPlayerOnline(uuid)) {
            return;
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.DEBUG_LOGINS).booleanValue()) {
            this.plugin.getLogger().info("User Housekeeper: unloading user data for " + uuid);
        }
        this.userManager.unload(uuid);
    }

    public static TimeoutSettings timeoutSettings(long duration, TimeUnit unit) {
        return new TimeoutSettings(duration, unit);
    }

    public static final class TimeoutSettings {
        private final long duration;
        private final TimeUnit unit;

        TimeoutSettings(long duration, TimeUnit unit) {
            this.duration = duration;
            this.unit = unit;
        }
    }
}

