/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.comparator;

import java.util.Comparator;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.PermissionNode;

public class NodeComparator
implements Comparator<Node> {
    private static final Comparator<? super Node> INSTANCE = new NodeComparator();
    private static final Comparator<? super Node> REVERSE = INSTANCE.reversed();

    public static Comparator<? super Node> normal() {
        return INSTANCE;
    }

    public static Comparator<? super Node> reverse() {
        return REVERSE;
    }

    @Override
    public int compare(Node o1, Node o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        int result = Boolean.compare(o1.hasExpiry(), o2.hasExpiry());
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(o1 instanceof PermissionNode && ((PermissionNode)o1).isWildcard(), o2 instanceof PermissionNode && ((PermissionNode)o2).isWildcard());
        if (result != 0) {
            return result;
        }
        if (o1.hasExpiry() && (result = o1.getExpiry().compareTo(o2.getExpiry())) != 0) {
            return result;
        }
        if (o1 instanceof PermissionNode && ((PermissionNode)o1).isWildcard() && (result = Integer.compare(((PermissionNode)o1).getWildcardLevel().getAsInt(), ((PermissionNode)o2).getWildcardLevel().getAsInt())) != 0) {
            return result;
        }
        result = -o1.getKey().compareTo(o2.getKey());
        if (result != 0) {
            return result;
        }
        result = -Boolean.compare(o1.getValue(), o2.getValue());
        if (result != 0) {
            return result;
        }
        throw new AssertionError((Object)("nodes are equal? " + o1 + " - " + o2));
    }
}

