/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.factory;

import me.lucko.luckperms.common.model.HolderType;
import net.luckperms.api.context.Context;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.MetaNode;

public final class NodeCommandFactory {
    private NodeCommandFactory() {
    }

    public static String generateCommand(Node node, String id, HolderType type, boolean set, boolean explicitGlobalContext) {
        StringBuilder sb = new StringBuilder(32);
        sb.append(type.toString()).append(" ").append(id).append(" ");
        if (node instanceof InheritanceNode) {
            sb.append("parent ");
            if (set) {
                sb.append("add");
            } else {
                sb.append("remove");
            }
            if (node.hasExpiry()) {
                sb.append("temp");
            }
            sb.append(" ").append(((InheritanceNode)node).getGroupName());
            if (node.hasExpiry() && set) {
                sb.append(" ").append(node.getExpiry().getEpochSecond());
            }
            return NodeCommandFactory.appendContextToCommand(sb, node, explicitGlobalContext).toString();
        }
        if (node.getValue() && node instanceof ChatMetaNode) {
            ChatMetaNode cmNode = (ChatMetaNode)node;
            sb.append("meta ");
            if (set) {
                sb.append("add");
            } else {
                sb.append("remove");
            }
            if (node.hasExpiry()) {
                sb.append("temp");
            }
            sb.append(cmNode.getMetaType().toString()).append(" ").append(cmNode.getPriority()).append(" ");
            String value = cmNode.getMetaValue();
            if (value.contains(" ")) {
                sb.append("\"").append(value).append("\"");
            } else {
                sb.append(value);
            }
            if (set && node.hasExpiry()) {
                sb.append(" ").append(node.getExpiry().getEpochSecond());
            }
            return NodeCommandFactory.appendContextToCommand(sb, node, explicitGlobalContext).toString();
        }
        if (node.getValue() && node instanceof MetaNode) {
            sb.append("meta ");
            if (set) {
                sb.append("set");
            } else {
                sb.append("unset");
            }
            if (node.hasExpiry()) {
                sb.append("temp");
            }
            sb.append(" ");
            MetaNode metaNode = (MetaNode)node;
            String key = metaNode.getMetaKey();
            if (key.contains(" ")) {
                sb.append("\"").append(key).append("\"");
            } else {
                sb.append(key);
            }
            if (set) {
                sb.append(" ");
                String value = metaNode.getMetaValue();
                if (value.contains(" ")) {
                    sb.append("\"").append(value).append("\"");
                } else {
                    sb.append(value);
                }
                if (node.hasExpiry()) {
                    sb.append(" ").append(node.getExpiry().getEpochSecond());
                }
            }
            return NodeCommandFactory.appendContextToCommand(sb, node, explicitGlobalContext).toString();
        }
        sb.append("permission ");
        if (set) {
            sb.append("set");
        } else {
            sb.append("unset");
        }
        if (node.hasExpiry()) {
            sb.append("temp");
        }
        sb.append(" ");
        String perm = node.getKey();
        if (perm.contains(" ")) {
            sb.append("\"").append(perm).append("\"");
        } else {
            sb.append(perm);
        }
        if (set) {
            sb.append(" ").append(node.getValue());
            if (node.hasExpiry()) {
                sb.append(" ").append(node.getExpiry().getEpochSecond());
            }
        }
        return NodeCommandFactory.appendContextToCommand(sb, node, explicitGlobalContext).toString();
    }

    private static StringBuilder appendContextToCommand(StringBuilder sb, Node node, boolean explicitGlobalContext) {
        if (node.getContexts().isEmpty()) {
            if (explicitGlobalContext) {
                sb.append(" global");
            }
            return sb;
        }
        for (Context context : node.getContexts()) {
            sb.append(" ").append(context.getKey()).append("=").append(context.getValue());
        }
        return sb;
    }
}

