/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.sender;

import com.google.common.base.Splitter;
import java.lang.ref.WeakReference;
import java.util.UUID;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.sender.SenderFactory;
import me.lucko.luckperms.common.util.TextUtils;
import me.lucko.luckperms.lib.text.Component;
import net.luckperms.api.util.Tristate;

public final class AbstractSender<T>
implements Sender {
    private static final Splitter NEW_LINE_SPLITTER = Splitter.on((String)"\n");
    private final LuckPermsPlugin platform;
    private final SenderFactory<T> factory;
    private final WeakReference<T> sender;
    private final UUID uniqueId;
    private final String name;

    AbstractSender(LuckPermsPlugin platform, SenderFactory<T> factory, T t) {
        this.platform = platform;
        this.factory = factory;
        this.sender = new WeakReference<T>(t);
        this.uniqueId = factory.getUniqueId(t);
        this.name = factory.getName(t);
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.platform;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void sendMessage(String message) {
        Object sender = this.sender.get();
        if (sender != null) {
            if (this.isConsole()) {
                for (String line : NEW_LINE_SPLITTER.split((CharSequence)message)) {
                    this.factory.sendMessage(sender, line);
                }
            } else {
                this.factory.sendMessage(sender, message);
            }
        }
    }

    @Override
    public void sendMessage(Component message) {
        if (this.isConsole()) {
            this.sendMessage(TextUtils.toLegacy(message));
            return;
        }
        Object sender = this.sender.get();
        if (sender != null) {
            this.factory.sendMessage(sender, message);
        }
    }

    @Override
    public Tristate getPermissionValue(String permission) {
        Object sender = this.sender.get();
        if (sender != null) {
            return this.factory.getPermissionValue(sender, permission);
        }
        return this.isConsole() ? Tristate.TRUE : Tristate.UNDEFINED;
    }

    @Override
    public boolean hasPermission(String permission) {
        Object sender = this.sender.get();
        if (sender != null && this.factory.hasPermission(sender, permission)) {
            return true;
        }
        return this.isConsole();
    }

    @Override
    public boolean isValid() {
        return this.sender.get() != null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSender)) {
            return false;
        }
        AbstractSender that = (AbstractSender)o;
        return this.getUniqueId().equals(that.getUniqueId());
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }
}

