/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.file;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.context.ContextSetConfigurateSerializer;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.node.types.Meta;
import me.lucko.luckperms.common.node.types.Prefix;
import me.lucko.luckperms.common.node.types.Suffix;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.StorageImplementation;
import me.lucko.luckperms.common.storage.implementation.file.CombinedConfigurateStorage;
import me.lucko.luckperms.common.storage.implementation.file.FileActionLogger;
import me.lucko.luckperms.common.storage.implementation.file.FileUuidCache;
import me.lucko.luckperms.common.storage.implementation.file.SeparatedConfigurateStorage;
import me.lucko.luckperms.common.storage.implementation.file.StorageLocation;
import me.lucko.luckperms.common.storage.implementation.file.loader.ConfigurateLoader;
import me.lucko.luckperms.common.storage.implementation.file.loader.JsonLoader;
import me.lucko.luckperms.common.storage.implementation.file.loader.YamlLoader;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.common.util.MoreFiles;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import me.lucko.luckperms.lib.configurate.SimpleConfigurationNode;
import me.lucko.luckperms.lib.configurate.Types;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.PlayerSaveResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeBuilder;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.MetaNode;

public abstract class AbstractConfigurateStorage
implements StorageImplementation {
    protected final LuckPermsPlugin plugin;
    private final String implementationName;
    protected final ConfigurateLoader loader;
    private final String dataDirectoryName;
    protected Path dataDirectory;
    private final FileUuidCache uuidCache = new FileUuidCache();
    private final FileActionLogger actionLogger;
    private Path uuidDataFile;

    protected AbstractConfigurateStorage(LuckPermsPlugin plugin, String implementationName, ConfigurateLoader loader, String dataDirectoryName) {
        this.plugin = plugin;
        this.implementationName = implementationName;
        this.loader = loader;
        this.dataDirectoryName = dataDirectoryName;
        this.actionLogger = new FileActionLogger(plugin);
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return this.implementationName;
    }

    protected abstract ConfigurationNode readFile(StorageLocation var1, String var2) throws IOException;

    protected abstract void saveFile(StorageLocation var1, String var2, ConfigurationNode var3) throws IOException;

    protected RuntimeException reportException(String file, Exception ex) throws RuntimeException {
        this.plugin.getLogger().warn("Exception thrown whilst performing i/o: " + file);
        ex.printStackTrace();
        Throwables.throwIfUnchecked((Throwable)ex);
        throw new RuntimeException(ex);
    }

    @Override
    public void init() throws IOException {
        this.dataDirectory = this.plugin.getBootstrap().getDataDirectory().resolve(this.dataDirectoryName);
        MoreFiles.createDirectoriesIfNotExists(this.dataDirectory);
        this.uuidDataFile = MoreFiles.createFileIfNotExists(this.dataDirectory.resolve("uuidcache.txt"));
        this.uuidCache.load(this.uuidDataFile);
        this.actionLogger.init(this.dataDirectory.resolve("actions.txt"), this.dataDirectory.resolve("actions.json"));
    }

    @Override
    public void shutdown() {
        this.uuidCache.save(this.uuidDataFile);
        this.actionLogger.flush();
    }

    @Override
    public void logAction(Action entry) {
        this.actionLogger.logAction(entry);
    }

    @Override
    public Log getLog() throws IOException {
        return this.actionLogger.getLog();
    }

    protected ConfigurationNode processBulkUpdate(BulkUpdate bulkUpdate, ConfigurationNode node) {
        Set<Node> nodes = AbstractConfigurateStorage.readNodes(node);
        Set<Node> results = nodes.stream().map(bulkUpdate::apply).filter(Objects::nonNull).collect(Collectors.toSet());
        if (nodes.equals(results)) {
            return null;
        }
        this.writeNodes(node, results);
        return node;
    }

    @Override
    public User loadUser(UUID uniqueId, String username) {
        User user = this.plugin.getUserManager().getOrMake(uniqueId, username);
        user.getIoLock().lock();
        try {
            ConfigurationNode object = this.readFile(StorageLocation.USER, uniqueId.toString());
            if (object != null) {
                String name = object.getNode(new Object[]{"name"}).getString();
                user.getPrimaryGroup().setStoredValue(object.getNode(new Object[]{this.loader instanceof JsonLoader ? "primaryGroup" : "primary-group"}).getString());
                user.setNodes(DataType.NORMAL, AbstractConfigurateStorage.readNodes(object));
                user.setUsername(name, true);
                boolean save = this.plugin.getUserManager().giveDefaultIfNeeded(user, false);
                if (user.getUsername().isPresent() && (name == null || !user.getUsername().get().equalsIgnoreCase(name))) {
                    save = true;
                }
                if (save | user.auditTemporaryNodes()) {
                    this.saveUser(user);
                }
            } else if (this.plugin.getUserManager().shouldSave(user)) {
                user.clearNodes(DataType.NORMAL, null, true);
                user.getPrimaryGroup().setStoredValue(null);
                this.plugin.getUserManager().giveDefaultIfNeeded(user, false);
            }
        }
        catch (Exception e) {
            throw this.reportException(uniqueId.toString(), e);
        }
        finally {
            user.getIoLock().unlock();
        }
        return user;
    }

    @Override
    public void saveUser(User user) {
        user.getIoLock().lock();
        try {
            if (!this.plugin.getUserManager().shouldSave(user)) {
                this.saveFile(StorageLocation.USER, user.getUniqueId().toString(), null);
            } else {
                SimpleConfigurationNode data = SimpleConfigurationNode.root();
                if (this instanceof SeparatedConfigurateStorage) {
                    data.getNode(new Object[]{"uuid"}).setValue((Object)user.getUniqueId().toString());
                }
                data.getNode(new Object[]{"name"}).setValue((Object)user.getUsername().orElse("null"));
                data.getNode(new Object[]{this.loader instanceof JsonLoader ? "primaryGroup" : "primary-group"}).setValue((Object)user.getPrimaryGroup().getStoredValue().orElse("default"));
                this.writeNodes((ConfigurationNode)data, (Collection<Node>)user.normalData().immutable().values());
                this.saveFile(StorageLocation.USER, user.getUniqueId().toString(), (ConfigurationNode)data);
            }
        }
        catch (Exception e) {
            throw this.reportException(user.getUniqueId().toString(), e);
        }
        finally {
            user.getIoLock().unlock();
        }
    }

    @Override
    public Group createAndLoadGroup(String name) {
        Group group = (Group)this.plugin.getGroupManager().getOrMake(name);
        group.getIoLock().lock();
        try {
            ConfigurationNode object = this.readFile(StorageLocation.GROUP, name);
            if (object != null) {
                group.setNodes(DataType.NORMAL, AbstractConfigurateStorage.readNodes(object));
            } else {
                SimpleConfigurationNode data = SimpleConfigurationNode.root();
                if (this instanceof SeparatedConfigurateStorage) {
                    data.getNode(new Object[]{"name"}).setValue((Object)group.getName());
                }
                this.writeNodes((ConfigurationNode)data, (Collection<Node>)group.normalData().immutable().values());
                this.saveFile(StorageLocation.GROUP, name, (ConfigurationNode)data);
            }
        }
        catch (Exception e) {
            throw this.reportException(name, e);
        }
        finally {
            group.getIoLock().unlock();
        }
        return group;
    }

    @Override
    public Optional<Group> loadGroup(String name) {
        Group group = (Group)this.plugin.getGroupManager().getIfLoaded(name);
        if (group != null) {
            group.getIoLock().lock();
        }
        try {
            ConfigurationNode object = this.readFile(StorageLocation.GROUP, name);
            if (object == null) {
                Optional<Group> optional = Optional.empty();
                return optional;
            }
            if (group == null) {
                group = (Group)this.plugin.getGroupManager().getOrMake(name);
                group.getIoLock().lock();
            }
            group.setNodes(DataType.NORMAL, AbstractConfigurateStorage.readNodes(object));
        }
        catch (Exception e) {
            throw this.reportException(name, e);
        }
        finally {
            if (group != null) {
                group.getIoLock().unlock();
            }
        }
        return Optional.of(group);
    }

    @Override
    public void saveGroup(Group group) {
        group.getIoLock().lock();
        try {
            SimpleConfigurationNode data = SimpleConfigurationNode.root();
            if (this instanceof SeparatedConfigurateStorage) {
                data.getNode(new Object[]{"name"}).setValue((Object)group.getName());
            }
            this.writeNodes((ConfigurationNode)data, (Collection<Node>)group.normalData().immutable().values());
            this.saveFile(StorageLocation.GROUP, group.getName(), (ConfigurationNode)data);
        }
        catch (Exception e) {
            throw this.reportException(group.getName(), e);
        }
        finally {
            group.getIoLock().unlock();
        }
    }

    @Override
    public void deleteGroup(Group group) {
        group.getIoLock().lock();
        try {
            this.saveFile(StorageLocation.GROUP, group.getName(), null);
        }
        catch (Exception e) {
            throw this.reportException(group.getName(), e);
        }
        finally {
            group.getIoLock().unlock();
        }
        this.plugin.getGroupManager().unload(group.getName());
    }

    @Override
    public Track createAndLoadTrack(String name) {
        Track track = (Track)this.plugin.getTrackManager().getOrMake(name);
        track.getIoLock().lock();
        try {
            ConfigurationNode object = this.readFile(StorageLocation.TRACK, name);
            if (object != null) {
                List groups = (List)object.getNode(new Object[]{"groups"}).getChildrenList().stream().map(ConfigurationNode::getString).collect(ImmutableCollectors.toList());
                track.setGroups(groups);
            } else {
                SimpleConfigurationNode data = SimpleConfigurationNode.root();
                if (this instanceof SeparatedConfigurateStorage) {
                    data.getNode(new Object[]{"name"}).setValue((Object)name);
                }
                data.getNode(new Object[]{"groups"}).setValue(track.getGroups());
                this.saveFile(StorageLocation.TRACK, name, (ConfigurationNode)data);
            }
        }
        catch (Exception e) {
            throw this.reportException(name, e);
        }
        finally {
            track.getIoLock().unlock();
        }
        return track;
    }

    @Override
    public Optional<Track> loadTrack(String name) {
        Track track = (Track)this.plugin.getTrackManager().getIfLoaded(name);
        if (track != null) {
            track.getIoLock().lock();
        }
        try {
            ConfigurationNode object = this.readFile(StorageLocation.TRACK, name);
            if (object == null) {
                Optional<Track> optional = Optional.empty();
                return optional;
            }
            if (track == null) {
                track = (Track)this.plugin.getTrackManager().getOrMake(name);
                track.getIoLock().lock();
            }
            List groups = (List)object.getNode(new Object[]{"groups"}).getChildrenList().stream().map(ConfigurationNode::getString).collect(ImmutableCollectors.toList());
            track.setGroups(groups);
        }
        catch (Exception e) {
            throw this.reportException(name, e);
        }
        finally {
            if (track != null) {
                track.getIoLock().unlock();
            }
        }
        return Optional.of(track);
    }

    @Override
    public void saveTrack(Track track) {
        track.getIoLock().lock();
        try {
            SimpleConfigurationNode data = SimpleConfigurationNode.root();
            if (this instanceof SeparatedConfigurateStorage) {
                data.getNode(new Object[]{"name"}).setValue((Object)track.getName());
            }
            data.getNode(new Object[]{"groups"}).setValue(track.getGroups());
            this.saveFile(StorageLocation.TRACK, track.getName(), (ConfigurationNode)data);
        }
        catch (Exception e) {
            throw this.reportException(track.getName(), e);
        }
        finally {
            track.getIoLock().unlock();
        }
    }

    @Override
    public void deleteTrack(Track track) {
        track.getIoLock().lock();
        try {
            this.saveFile(StorageLocation.TRACK, track.getName(), null);
        }
        catch (Exception e) {
            throw this.reportException(track.getName(), e);
        }
        finally {
            track.getIoLock().unlock();
        }
        this.plugin.getTrackManager().unload(track.getName());
    }

    @Override
    public PlayerSaveResult savePlayerData(UUID uniqueId, String username) {
        return this.uuidCache.addMapping(uniqueId, username);
    }

    @Override
    public UUID getPlayerUniqueId(String username) {
        return this.uuidCache.lookupUuid(username);
    }

    @Override
    public String getPlayerName(UUID uniqueId) {
        return this.uuidCache.lookupUsername(uniqueId);
    }

    private static ImmutableContextSet readContexts(ConfigurationNode attributes) {
        String world;
        String server;
        ImmutableContextSetImpl.BuilderImpl contextBuilder = new ImmutableContextSetImpl.BuilderImpl();
        ConfigurationNode contextMap = attributes.getNode(new Object[]{"context"});
        if (!contextMap.isVirtual() && contextMap.hasMapChildren()) {
            contextBuilder.addAll(ContextSetConfigurateSerializer.deserializeContextSet(contextMap));
        }
        if (!(server = attributes.getNode(new Object[]{"server"}).getString("global")).equals("global")) {
            contextBuilder.add("server", server);
        }
        if (!(world = attributes.getNode(new Object[]{"world"}).getString("global")).equals("global")) {
            contextBuilder.add("world", world);
        }
        return contextBuilder.build();
    }

    private static Node readMetaAttributes(ConfigurationNode attributes, Function<ConfigurationNode, NodeBuilder<?, ?>> permissionFunction) {
        boolean value = attributes.getNode(new Object[]{"value"}).getBoolean(true);
        long expiryVal = attributes.getNode(new Object[]{"expiry"}).getLong(0L);
        Instant expiry = expiryVal == 0L ? null : Instant.ofEpochSecond(expiryVal);
        ImmutableContextSet context = AbstractConfigurateStorage.readContexts(attributes);
        return permissionFunction.apply(attributes).value(value).expiry(expiry).context(context).build();
    }

    private static Collection<Node> readAttributes(ConfigurationNode attributes, String permission) {
        boolean value = attributes.getNode(new Object[]{"value"}).getBoolean(true);
        long expiryVal = attributes.getNode(new Object[]{"expiry"}).getLong(0L);
        Instant expiry = expiryVal == 0L ? null : Instant.ofEpochSecond(expiryVal);
        ImmutableContextSet context = AbstractConfigurateStorage.readContexts(attributes);
        ConfigurationNode batchAttribute = attributes.getNode(new Object[]{"permissions"});
        if (permission.startsWith("luckperms.batch") && !batchAttribute.isVirtual() && batchAttribute.hasListChildren()) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (ConfigurationNode element : batchAttribute.getChildrenList()) {
                Object node = NodeBuilders.determineMostApplicable(element.getString()).value(value).expiry(expiry).context(context).build();
                nodes.add((Node)node);
            }
            return nodes;
        }
        Object node = NodeBuilders.determineMostApplicable(permission).value(value).expiry(expiry).context(context).build();
        return Collections.singleton(node);
    }

    private static Map.Entry<String, ConfigurationNode> parseEntry(ConfigurationNode appended, String keyFieldName) {
        String permission;
        Map.Entry entry;
        if (!appended.hasMapChildren()) {
            return null;
        }
        Map children = appended.getChildrenMap();
        if (children.isEmpty()) {
            return null;
        }
        if (children.size() == 1 && (entry = (Map.Entry)Iterables.getFirst(children.entrySet(), null)) != null) {
            String permission2 = entry.getKey().toString();
            ConfigurationNode attributes = (ConfigurationNode)entry.getValue();
            if (!permission2.equals(keyFieldName)) {
                return Maps.immutableEntry((Object)permission2, (Object)attributes);
            }
        }
        if ((permission = ((ConfigurationNode)children.get(keyFieldName)).getString(null)) == null) {
            return null;
        }
        return Maps.immutableEntry((Object)permission, (Object)appended);
    }

    protected static Set<Node> readNodes(ConfigurationNode data) {
        Map.Entry<String, ConfigurationNode> entry;
        Map.Entry<String, ConfigurationNode> entry2;
        String plainValue;
        List children;
        HashSet<Node> nodes = new HashSet<Node>();
        if (data.getNode(new Object[]{"permissions"}).hasListChildren()) {
            children = data.getNode(new Object[]{"permissions"}).getChildrenList();
            for (ConfigurationNode appended : children) {
                plainValue = (String)appended.getValue(Types::strictAsString);
                if (plainValue != null) {
                    nodes.add((Node)NodeBuilders.determineMostApplicable(plainValue).build());
                    continue;
                }
                entry2 = AbstractConfigurateStorage.parseEntry(appended, "permission");
                if (entry2 == null) continue;
                nodes.addAll(AbstractConfigurateStorage.readAttributes(entry2.getValue(), entry2.getKey()));
            }
        }
        if (data.getNode(new Object[]{"parents"}).hasListChildren()) {
            children = data.getNode(new Object[]{"parents"}).getChildrenList();
            for (ConfigurationNode appended : children) {
                plainValue = (String)appended.getValue(Types::strictAsString);
                if (plainValue != null) {
                    nodes.add(Inheritance.builder(plainValue).build());
                    continue;
                }
                entry2 = AbstractConfigurateStorage.parseEntry(appended, "group");
                if (entry2 == null) continue;
                nodes.add(AbstractConfigurateStorage.readMetaAttributes(entry2.getValue(), c -> Inheritance.builder((String)entry2.getKey())));
            }
        }
        if (data.getNode(new Object[]{"prefixes"}).hasListChildren()) {
            children = data.getNode(new Object[]{"prefixes"}).getChildrenList();
            for (ConfigurationNode appended : children) {
                entry = AbstractConfigurateStorage.parseEntry(appended, "prefix");
                if (entry == null) continue;
                nodes.add(AbstractConfigurateStorage.readMetaAttributes(entry.getValue(), c -> Prefix.builder((String)entry.getKey(), c.getNode(new Object[]{"priority"}).getInt(0))));
            }
        }
        if (data.getNode(new Object[]{"suffixes"}).hasListChildren()) {
            children = data.getNode(new Object[]{"suffixes"}).getChildrenList();
            for (ConfigurationNode appended : children) {
                entry = AbstractConfigurateStorage.parseEntry(appended, "suffix");
                if (entry == null) continue;
                nodes.add(AbstractConfigurateStorage.readMetaAttributes(entry.getValue(), c -> Suffix.builder((String)entry.getKey(), c.getNode(new Object[]{"priority"}).getInt(0))));
            }
        }
        if (data.getNode(new Object[]{"meta"}).hasListChildren()) {
            children = data.getNode(new Object[]{"meta"}).getChildrenList();
            for (ConfigurationNode appended : children) {
                entry = AbstractConfigurateStorage.parseEntry(appended, "key");
                if (entry == null) continue;
                nodes.add(AbstractConfigurateStorage.readMetaAttributes(entry.getValue(), c -> Meta.builder((String)entry.getKey(), c.getNode(new Object[]{"value"}).getString("null"))));
            }
        }
        return nodes;
    }

    private static void writeAttributesTo(ConfigurationNode attributes, Node node, boolean writeValue) {
        if (writeValue) {
            attributes.getNode(new Object[]{"value"}).setValue((Object)node.getValue());
        }
        if (node.hasExpiry()) {
            attributes.getNode(new Object[]{"expiry"}).setValue((Object)node.getExpiry().getEpochSecond());
        }
        if (!node.getContexts().isEmpty()) {
            attributes.getNode(new Object[]{"context"}).setValue((Object)ContextSetConfigurateSerializer.serializeContextSet(node.getContexts()));
        }
    }

    private static boolean isPlain(Node node) {
        return node.getValue() && !node.hasExpiry() && node.getContexts().isEmpty();
    }

    private void appendNode(ConfigurationNode base, String key, ConfigurationNode attributes, String keyFieldName) {
        ConfigurationNode appended = base.getAppendedNode();
        if (this.loader instanceof YamlLoader) {
            appended.getNode(new Object[]{key}).setValue((Object)attributes);
        } else {
            appended.getNode(new Object[]{keyFieldName}).setValue((Object)key);
            appended.mergeValuesFrom(attributes);
        }
    }

    private void writeNodes(ConfigurationNode to, Collection<Node> nodes) {
        SimpleConfigurationNode permissionsSection = SimpleConfigurationNode.root();
        SimpleConfigurationNode parentsSection = SimpleConfigurationNode.root();
        SimpleConfigurationNode prefixesSection = SimpleConfigurationNode.root();
        SimpleConfigurationNode suffixesSection = SimpleConfigurationNode.root();
        SimpleConfigurationNode metaSection = SimpleConfigurationNode.root();
        for (Node n : nodes) {
            SimpleConfigurationNode attributes;
            if (this.loader instanceof YamlLoader && AbstractConfigurateStorage.isPlain(n)) {
                if (n instanceof InheritanceNode) {
                    parentsSection.getAppendedNode().setValue((Object)((InheritanceNode)n).getGroupName());
                    continue;
                }
                if (!NodeType.META_OR_CHAT_META.matches(n)) {
                    permissionsSection.getAppendedNode().setValue((Object)n.getKey());
                    continue;
                }
            }
            if (n instanceof ChatMetaNode && n.getValue()) {
                ChatMetaNode chatMeta = (ChatMetaNode)n;
                attributes = SimpleConfigurationNode.root();
                attributes.getNode(new Object[]{"priority"}).setValue((Object)chatMeta.getPriority());
                AbstractConfigurateStorage.writeAttributesTo((ConfigurationNode)attributes, n, false);
                switch (chatMeta.getMetaType()) {
                    case PREFIX: {
                        this.appendNode((ConfigurationNode)prefixesSection, chatMeta.getMetaValue(), (ConfigurationNode)attributes, "prefix");
                        break;
                    }
                    case SUFFIX: {
                        this.appendNode((ConfigurationNode)suffixesSection, chatMeta.getMetaValue(), (ConfigurationNode)attributes, "suffix");
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                continue;
            }
            if (n instanceof MetaNode && n.getValue()) {
                MetaNode meta = (MetaNode)n;
                attributes = SimpleConfigurationNode.root();
                attributes.getNode(new Object[]{"value"}).setValue((Object)meta.getMetaValue());
                AbstractConfigurateStorage.writeAttributesTo((ConfigurationNode)attributes, n, false);
                this.appendNode((ConfigurationNode)metaSection, meta.getMetaKey(), (ConfigurationNode)attributes, "key");
                continue;
            }
            if (n instanceof InheritanceNode && n.getValue()) {
                InheritanceNode inheritance = (InheritanceNode)n;
                attributes = SimpleConfigurationNode.root();
                AbstractConfigurateStorage.writeAttributesTo((ConfigurationNode)attributes, n, false);
                this.appendNode((ConfigurationNode)parentsSection, inheritance.getGroupName(), (ConfigurationNode)attributes, "group");
                continue;
            }
            SimpleConfigurationNode attributes2 = SimpleConfigurationNode.root();
            AbstractConfigurateStorage.writeAttributesTo((ConfigurationNode)attributes2, n, true);
            this.appendNode((ConfigurationNode)permissionsSection, n.getKey(), (ConfigurationNode)attributes2, "permission");
        }
        if (permissionsSection.hasListChildren() || this instanceof CombinedConfigurateStorage) {
            if (!permissionsSection.hasListChildren()) {
                permissionsSection.setValue(Collections.emptyList());
            }
            to.getNode(new Object[]{"permissions"}).setValue((Object)permissionsSection);
        }
        if (parentsSection.hasListChildren()) {
            to.getNode(new Object[]{"parents"}).setValue((Object)parentsSection);
        }
        if (prefixesSection.hasListChildren()) {
            to.getNode(new Object[]{"prefixes"}).setValue((Object)prefixesSection);
        }
        if (suffixesSection.hasListChildren()) {
            to.getNode(new Object[]{"suffixes"}).setValue((Object)suffixesSection);
        }
        if (metaSection.hasListChildren()) {
            to.getNode(new Object[]{"meta"}).setValue((Object)metaSection);
        }
    }
}

