/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.file.watcher;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractFileWatcher
implements AutoCloseable {
    private final WatchService service;
    private final Map<WatchKey, Path> keys = Collections.synchronizedMap(new HashMap());
    private final boolean autoRegisterNewSubDirectories;
    private final AtomicReference<Thread> processingThread = new AtomicReference();

    private static WatchKey register(WatchService watchService, Path directory) throws IOException {
        return directory.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    public AbstractFileWatcher(FileSystem fileSystem, boolean autoRegisterNewSubDirectories) throws IOException {
        this.service = fileSystem.newWatchService();
        this.autoRegisterNewSubDirectories = autoRegisterNewSubDirectories;
    }

    public void register(Path directory) throws IOException {
        WatchKey key = AbstractFileWatcher.register(this.service, directory);
        this.keys.put(key, directory);
    }

    public void registerRecursively(Path root) throws IOException {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                AbstractFileWatcher.this.register(dir);
                return super.preVisitDirectory(dir, attrs);
            }
        });
    }

    protected abstract void processEvent(WatchEvent<Path> var1, Path var2);

    public final void runEventProcessingLoop() {
        if (!this.processingThread.compareAndSet(null, Thread.currentThread())) {
            throw new IllegalStateException("A thread is already processing events for this watcher.");
        }
        while (true) {
            WatchKey key;
            try {
                key = this.service.take();
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                break;
            }
            Path directory = this.keys.get(key);
            if (directory == null) {
                key.cancel();
                continue;
            }
            for (WatchEvent<Path> watchEvent : key.pollEvents()) {
                WatchEvent<Path> event = watchEvent;
                Path context = (Path)event.context();
                if (context.getNameCount() == 0) continue;
                Path file = directory.resolve(context);
                if (Files.isRegularFile(file, new LinkOption[0])) {
                    this.processEvent(event, file);
                }
                if (!this.autoRegisterNewSubDirectories || event.kind() != StandardWatchEventKinds.ENTRY_CREATE) continue;
                try {
                    if (!Files.isDirectory(file, LinkOption.NOFOLLOW_LINKS)) continue;
                    this.registerRecursively(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
        }
        this.processingThread.compareAndSet(Thread.currentThread(), null);
    }

    @Override
    public void close() {
        try {
            this.service.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

