/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.mongodb;

import com.google.common.base.Strings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.context.contextset.MutableContextSetImpl;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.StorageImplementation;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.storage.misc.PlayerSaveResultImpl;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.common.util.Iterators;
import me.lucko.luckperms.lib.bson.Document;
import me.lucko.luckperms.lib.bson.conversions.Bson;
import me.lucko.luckperms.lib.mongodb.MongoClient;
import me.lucko.luckperms.lib.mongodb.MongoClientOptions;
import me.lucko.luckperms.lib.mongodb.MongoClientURI;
import me.lucko.luckperms.lib.mongodb.MongoCredential;
import me.lucko.luckperms.lib.mongodb.ServerAddress;
import me.lucko.luckperms.lib.mongodb.client.MongoCollection;
import me.lucko.luckperms.lib.mongodb.client.MongoCursor;
import me.lucko.luckperms.lib.mongodb.client.MongoDatabase;
import me.lucko.luckperms.lib.mongodb.client.model.Filters;
import me.lucko.luckperms.lib.mongodb.client.model.ReplaceOptions;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.PlayerSaveResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;

public class MongoStorage
implements StorageImplementation {
    private final LuckPermsPlugin plugin;
    private final StorageCredentials configuration;
    private MongoClient mongoClient;
    private MongoDatabase database;
    private final String prefix;
    private final String connectionUri;

    public MongoStorage(LuckPermsPlugin plugin, StorageCredentials configuration, String prefix, String connectionUri) {
        this.plugin = plugin;
        this.configuration = configuration;
        this.prefix = prefix;
        this.connectionUri = connectionUri;
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return "MongoDB";
    }

    @Override
    public void init() {
        if (!Strings.isNullOrEmpty((String)this.connectionUri)) {
            this.mongoClient = new MongoClient(new MongoClientURI(this.connectionUri));
        } else {
            MongoCredential credential = null;
            if (!Strings.isNullOrEmpty((String)this.configuration.getUsername())) {
                credential = MongoCredential.createCredential((String)this.configuration.getUsername(), (String)this.configuration.getDatabase(), Strings.isNullOrEmpty((String)this.configuration.getPassword()) ? null : this.configuration.getPassword().toCharArray());
            }
            String[] addressSplit = this.configuration.getAddress().split(":");
            String host = addressSplit[0];
            int port = addressSplit.length > 1 ? Integer.parseInt(addressSplit[1]) : 27017;
            ServerAddress address = new ServerAddress(host, port);
            this.mongoClient = credential == null ? new MongoClient(address) : new MongoClient(address, credential, MongoClientOptions.builder().build());
        }
        this.database = this.mongoClient.getDatabase(this.configuration.getDatabase());
    }

    @Override
    public void shutdown() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    @Override
    public Map<String, String> getMeta() {
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>();
        boolean success = true;
        long start = System.currentTimeMillis();
        try {
            this.database.runCommand((Bson)new Document("ping", (Object)1));
        }
        catch (Exception e) {
            success = false;
        }
        long duration = System.currentTimeMillis() - start;
        if (success) {
            meta.put("Ping", "&a" + duration + "ms");
            meta.put("Connected", "true");
        } else {
            meta.put("Connected", "false");
        }
        return meta;
    }

    @Override
    public void logAction(Action entry) {
        MongoCollection c = this.database.getCollection(this.prefix + "action");
        Document doc = new Document().append("timestamp", (Object)entry.getTimestamp().getEpochSecond()).append("source", (Object)new Document().append("uniqueId", (Object)entry.getSource().getUniqueId()).append("name", (Object)entry.getSource().getName()));
        Document target = new Document().append("type", (Object)entry.getTarget().getType().name()).append("name", (Object)entry.getTarget().getName());
        if (entry.getTarget().getUniqueId().isPresent()) {
            target.append("uniqueId", (Object)entry.getTarget().getUniqueId().get());
        }
        doc.append("target", (Object)target);
        doc.append("description", (Object)entry.getDescription());
        c.insertOne((Object)doc);
    }

    @Override
    public Log getLog() {
        Log.Builder log = Log.builder();
        MongoCollection c = this.database.getCollection(this.prefix + "action");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                Document d = (Document)cursor.next();
                if (d.containsKey((Object)"source")) {
                    Document source = (Document)d.get((Object)"source", Document.class);
                    Document target = (Document)d.get((Object)"target", Document.class);
                    UUID targetUniqueId = null;
                    if (target.containsKey((Object)"uniqueId")) {
                        targetUniqueId = (UUID)target.get((Object)"uniqueId", UUID.class);
                    }
                    LoggedAction e = LoggedAction.build().timestamp(Instant.ofEpochSecond(d.getLong((Object)"timestamp"))).source((UUID)source.get((Object)"uniqueId", UUID.class)).sourceName(source.getString((Object)"name")).targetType(LoggedAction.parseType(target.getString((Object)"type"))).target(targetUniqueId).targetName(target.getString((Object)"name")).description(d.getString((Object)"description")).build();
                    log.add(e);
                    continue;
                }
                UUID actedUuid = null;
                if (d.containsKey((Object)"acted")) {
                    actedUuid = (UUID)d.get((Object)"acted", UUID.class);
                }
                LoggedAction e = LoggedAction.build().timestamp(Instant.ofEpochSecond(d.getLong((Object)"timestamp"))).source((UUID)d.get((Object)"actor", UUID.class)).sourceName(d.getString((Object)"actorName")).targetType(LoggedAction.parseTypeCharacter(d.getString((Object)"type").charAt(0))).target(actedUuid).targetName(d.getString((Object)"actedName")).description(d.getString((Object)"action")).build();
                log.add(e);
            }
        }
        return log.build();
    }

    @Override
    public void applyBulkUpdate(BulkUpdate bulkUpdate) {
        List newNodes;
        Set results;
        HashSet<Node> nodes;
        Document d2;
        Throwable throwable;
        MongoCursor cursor;
        MongoCollection c;
        if (bulkUpdate.getDataType().isIncludingUsers()) {
            c = this.database.getCollection(this.prefix + "users");
            cursor = c.find().iterator();
            throwable = null;
            try {
                while (cursor.hasNext()) {
                    d2 = (Document)cursor.next();
                    UUID uuid = MongoStorage.getDocumentId(d2);
                    nodes = new HashSet<Node>(MongoStorage.nodesFromDoc(d2));
                    results = nodes.stream().map(bulkUpdate::apply).filter(Objects::nonNull).collect(Collectors.toSet());
                    if (nodes.equals(results)) continue;
                    newNodes = results.stream().map(MongoStorage::nodeToDoc).collect(Collectors.toList());
                    d2.append("permissions", newNodes).remove((Object)"perms");
                    c.replaceOne((Bson)new Document("_id", (Object)uuid), (Object)d2);
                }
            }
            catch (Throwable d2) {
                throwable = d2;
                throw d2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable d2) {
                            throwable.addSuppressed(d2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        if (bulkUpdate.getDataType().isIncludingGroups()) {
            c = this.database.getCollection(this.prefix + "groups");
            cursor = c.find().iterator();
            throwable = null;
            try {
                while (cursor.hasNext()) {
                    d2 = (Document)cursor.next();
                    String holder = d2.getString((Object)"_id");
                    nodes = new HashSet<Node>(MongoStorage.nodesFromDoc(d2));
                    results = nodes.stream().map(bulkUpdate::apply).filter(Objects::nonNull).collect(Collectors.toSet());
                    if (nodes.equals(results)) continue;
                    newNodes = results.stream().map(MongoStorage::nodeToDoc).collect(Collectors.toList());
                    d2.append("permissions", newNodes).remove((Object)"perms");
                    c.replaceOne((Bson)new Document("_id", (Object)holder), (Object)d2);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User loadUser(UUID uniqueId, String username) {
        User user = this.plugin.getUserManager().getOrMake(uniqueId, username);
        user.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "users");
            try (MongoCursor cursor = c.find((Bson)new Document("_id", (Object)user.getUniqueId())).iterator();){
                if (cursor.hasNext()) {
                    Document d = (Document)cursor.next();
                    String name = d.getString((Object)"name");
                    user.getPrimaryGroup().setStoredValue(d.getString((Object)"primaryGroup"));
                    user.setNodes(DataType.NORMAL, MongoStorage.nodesFromDoc(d));
                    user.setUsername(name, true);
                    boolean save = this.plugin.getUserManager().giveDefaultIfNeeded(user, false);
                    if (user.getUsername().isPresent() && (name == null || !user.getUsername().get().equalsIgnoreCase(name))) {
                        save = true;
                    }
                    if (save | user.auditTemporaryNodes()) {
                        c.replaceOne((Bson)new Document("_id", (Object)user.getUniqueId()), (Object)MongoStorage.userToDoc(user));
                    }
                } else if (this.plugin.getUserManager().shouldSave(user)) {
                    user.clearNodes(DataType.NORMAL, null, true);
                    user.getPrimaryGroup().setStoredValue(null);
                    this.plugin.getUserManager().giveDefaultIfNeeded(user, false);
                }
            }
        }
        finally {
            user.getIoLock().unlock();
        }
        return user;
    }

    @Override
    public void saveUser(User user) {
        user.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "users");
            if (!this.plugin.getUserManager().shouldSave(user)) {
                c.deleteOne((Bson)new Document("_id", (Object)user.getUniqueId()));
            } else {
                c.replaceOne((Bson)new Document("_id", (Object)user.getUniqueId()), (Object)MongoStorage.userToDoc(user), new ReplaceOptions().upsert(true));
            }
        }
        finally {
            user.getIoLock().unlock();
        }
    }

    @Override
    public Set<UUID> getUniqueUsers() {
        HashSet<UUID> uuids = new HashSet<UUID>();
        MongoCollection c = this.database.getCollection(this.prefix + "users");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                uuids.add(MongoStorage.getDocumentId((Document)cursor.next()));
            }
        }
        return uuids;
    }

    @Override
    public <N extends Node> List<NodeEntry<UUID, N>> getUsersWithPermission(ConstraintNodeMatcher<N> constraint) throws Exception {
        ArrayList<NodeEntry<UUID, N>> held = new ArrayList<NodeEntry<UUID, N>>();
        MongoCollection c = this.database.getCollection(this.prefix + "users");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                Document d = (Document)cursor.next();
                UUID holder = MongoStorage.getDocumentId(d);
                HashSet<Node> nodes = new HashSet<Node>(MongoStorage.nodesFromDoc(d));
                for (Node e : nodes) {
                    N match = constraint.match(e);
                    if (match == null) continue;
                    held.add(NodeEntry.of(holder, match));
                }
            }
        }
        return held;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createAndLoadGroup(String name) {
        Group group = (Group)this.plugin.getGroupManager().getOrMake(name);
        group.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "groups");
            try (MongoCursor cursor = c.find((Bson)new Document("_id", (Object)group.getName())).iterator();){
                if (cursor.hasNext()) {
                    Document d = (Document)cursor.next();
                    group.setNodes(DataType.NORMAL, MongoStorage.nodesFromDoc(d));
                } else {
                    c.insertOne((Object)MongoStorage.groupToDoc(group));
                }
            }
        }
        finally {
            group.getIoLock().unlock();
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Group> loadGroup(String name) {
        Group group = (Group)this.plugin.getGroupManager().getIfLoaded(name);
        if (group != null) {
            group.getIoLock().lock();
        }
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "groups");
            try (MongoCursor cursor = c.find((Bson)new Document("_id", (Object)name)).iterator();){
                if (!cursor.hasNext()) {
                    Optional<Group> optional = Optional.empty();
                    return optional;
                }
                if (group == null) {
                    group = (Group)this.plugin.getGroupManager().getOrMake(name);
                    group.getIoLock().lock();
                }
                Document d = (Document)cursor.next();
                group.setNodes(DataType.NORMAL, MongoStorage.nodesFromDoc(d));
            }
        }
        finally {
            if (group != null) {
                group.getIoLock().unlock();
            }
        }
        return Optional.of(group);
    }

    @Override
    public void loadAllGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        MongoCollection c = this.database.getCollection(this.prefix + "groups");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                String name = ((Document)cursor.next()).getString((Object)"_id");
                groups.add(name);
            }
        }
        if (!Iterators.tryIterate(groups, this::loadGroup)) {
            throw new RuntimeException("Exception occurred whilst loading a group");
        }
        this.plugin.getGroupManager().retainAll(groups);
    }

    @Override
    public void saveGroup(Group group) {
        group.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "groups");
            c.replaceOne((Bson)new Document("_id", (Object)group.getName()), (Object)MongoStorage.groupToDoc(group), new ReplaceOptions().upsert(true));
        }
        finally {
            group.getIoLock().unlock();
        }
    }

    @Override
    public void deleteGroup(Group group) {
        group.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "groups");
            c.deleteOne((Bson)new Document("_id", (Object)group.getName()));
        }
        finally {
            group.getIoLock().unlock();
        }
    }

    @Override
    public <N extends Node> List<NodeEntry<String, N>> getGroupsWithPermission(ConstraintNodeMatcher<N> constraint) throws Exception {
        ArrayList<NodeEntry<String, N>> held = new ArrayList<NodeEntry<String, N>>();
        MongoCollection c = this.database.getCollection(this.prefix + "groups");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                Document d = (Document)cursor.next();
                String holder = d.getString((Object)"_id");
                HashSet<Node> nodes = new HashSet<Node>(MongoStorage.nodesFromDoc(d));
                for (Node e : nodes) {
                    N match = constraint.match(e);
                    if (match == null) continue;
                    held.add(NodeEntry.of(holder, match));
                }
            }
        }
        return held;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Track createAndLoadTrack(String name) {
        Track track = (Track)this.plugin.getTrackManager().getOrMake(name);
        track.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "tracks");
            try (MongoCursor cursor = c.find((Bson)new Document("_id", (Object)track.getName())).iterator();){
                if (!cursor.hasNext()) {
                    c.insertOne((Object)MongoStorage.trackToDoc(track));
                } else {
                    Document d = (Document)cursor.next();
                    track.setGroups((List)d.get((Object)"groups"));
                }
            }
        }
        finally {
            track.getIoLock().unlock();
        }
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Track> loadTrack(String name) {
        Track track = (Track)this.plugin.getTrackManager().getIfLoaded(name);
        if (track != null) {
            track.getIoLock().lock();
        }
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "tracks");
            try (MongoCursor cursor = c.find((Bson)new Document("_id", (Object)name)).iterator();){
                if (!cursor.hasNext()) {
                    Optional<Track> optional = Optional.empty();
                    return optional;
                }
                if (track == null) {
                    track = (Track)this.plugin.getTrackManager().getOrMake(name);
                    track.getIoLock().lock();
                }
                Document d = (Document)cursor.next();
                track.setGroups((List)d.get((Object)"groups"));
            }
        }
        finally {
            if (track != null) {
                track.getIoLock().unlock();
            }
        }
        return Optional.of(track);
    }

    @Override
    public void loadAllTracks() {
        ArrayList<String> tracks = new ArrayList<String>();
        MongoCollection c = this.database.getCollection(this.prefix + "tracks");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                String name = ((Document)cursor.next()).getString((Object)"_id");
                tracks.add(name);
            }
        }
        if (!Iterators.tryIterate(tracks, this::loadTrack)) {
            throw new RuntimeException("Exception occurred whilst loading a track");
        }
        this.plugin.getTrackManager().retainAll(tracks);
    }

    @Override
    public void saveTrack(Track track) {
        track.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "tracks");
            c.replaceOne((Bson)new Document("_id", (Object)track.getName()), (Object)MongoStorage.trackToDoc(track));
        }
        finally {
            track.getIoLock().unlock();
        }
    }

    @Override
    public void deleteTrack(Track track) {
        track.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "tracks");
            c.deleteOne((Bson)new Document("_id", (Object)track.getName()));
        }
        finally {
            track.getIoLock().unlock();
        }
    }

    @Override
    public PlayerSaveResult savePlayerData(UUID uniqueId, String username) {
        username = username.toLowerCase();
        MongoCollection c = this.database.getCollection(this.prefix + "uuid");
        String oldUsername = this.getPlayerName(uniqueId);
        if (!username.equalsIgnoreCase(oldUsername)) {
            c.replaceOne((Bson)new Document("_id", (Object)uniqueId), (Object)new Document("_id", (Object)uniqueId).append("name", (Object)username), new ReplaceOptions().upsert(true));
        }
        PlayerSaveResultImpl result = PlayerSaveResultImpl.determineBaseResult(username, oldUsername);
        HashSet<UUID> conflicting = new HashSet<UUID>();
        try (MongoCursor cursor = c.find((Bson)new Document("name", (Object)username)).iterator();){
            while (cursor.hasNext()) {
                conflicting.add(MongoStorage.getDocumentId((Document)cursor.next()));
            }
        }
        conflicting.remove(uniqueId);
        if (!conflicting.isEmpty()) {
            c.deleteMany(Filters.and((Iterable)conflicting.stream().map(u -> Filters.eq((String)"_id", (Object)u)).collect(Collectors.toList())));
            result = result.withOtherUuidsPresent(conflicting);
        }
        return result;
    }

    @Override
    public UUID getPlayerUniqueId(String username) {
        MongoCollection c = this.database.getCollection(this.prefix + "uuid");
        Document doc = (Document)c.find((Bson)new Document("name", (Object)username.toLowerCase())).first();
        if (doc != null) {
            return MongoStorage.getDocumentId(doc);
        }
        return null;
    }

    @Override
    public String getPlayerName(UUID uniqueId) {
        MongoCollection c = this.database.getCollection(this.prefix + "uuid");
        Document doc = (Document)c.find((Bson)new Document("_id", (Object)uniqueId)).first();
        if (doc != null) {
            return (String)doc.get((Object)"name", String.class);
        }
        return null;
    }

    private static UUID getDocumentId(Document doc) {
        Object id = doc.get((Object)"_id");
        if (id instanceof UUID) {
            return (UUID)id;
        }
        if (id instanceof String) {
            return UUID.fromString((String)id);
        }
        throw new IllegalArgumentException("Unknown id type: " + id.getClass().getName());
    }

    private static Document userToDoc(User user) {
        List nodes = user.normalData().immutable().values().stream().map(MongoStorage::nodeToDoc).collect(Collectors.toList());
        return new Document("_id", (Object)user.getUniqueId()).append("name", (Object)user.getUsername().orElse("null")).append("primaryGroup", (Object)user.getPrimaryGroup().getStoredValue().orElse("default")).append("permissions", nodes);
    }

    private static List<Node> nodesFromDoc(Document document) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (document.containsKey((Object)"permissions") && document.get((Object)"permissions") instanceof List) {
            List permsList = (List)document.get((Object)"permissions");
            for (Document d : permsList) {
                nodes.add(MongoStorage.nodeFromDoc(d));
            }
        }
        return nodes;
    }

    private static Document groupToDoc(Group group) {
        List nodes = group.normalData().immutable().values().stream().map(MongoStorage::nodeToDoc).collect(Collectors.toList());
        return new Document("_id", (Object)group.getName()).append("permissions", nodes);
    }

    private static Document trackToDoc(Track track) {
        return new Document("_id", (Object)track.getName()).append("groups", track.getGroups());
    }

    private static Document nodeToDoc(Node node) {
        Document document = new Document();
        document.append("key", (Object)node.getKey());
        document.append("value", (Object)node.getValue());
        Instant expiry = node.getExpiry();
        if (expiry != null) {
            document.append("expiry", (Object)expiry.getEpochSecond());
        }
        if (!node.getContexts().isEmpty()) {
            document.append("context", MongoStorage.contextSetToDocs(node.getContexts()));
        }
        return document;
    }

    private static Node nodeFromDoc(Document document) {
        String key = document.containsKey((Object)"permission") ? document.getString((Object)"permission") : document.getString((Object)"key");
        Object builder = NodeBuilders.determineMostApplicable(key).value(document.getBoolean((Object)"value", true));
        if (document.containsKey((Object)"server")) {
            builder.withContext("server", document.getString((Object)"server"));
        }
        if (document.containsKey((Object)"world")) {
            builder.withContext("world", document.getString((Object)"world"));
        }
        if (document.containsKey((Object)"expiry")) {
            builder.expiry(document.getLong((Object)"expiry"));
        }
        if (document.containsKey((Object)"context") && document.get((Object)"context") instanceof List) {
            List contexts = (List)document.get((Object)"context");
            builder.withContext(MongoStorage.docsToContextSet(contexts));
        }
        return builder.build();
    }

    private static List<Document> contextSetToDocs(ContextSet contextSet) {
        ArrayList<Document> contexts = new ArrayList<Document>(contextSet.size());
        for (Context e : contextSet) {
            contexts.add(new Document().append("key", (Object)e.getKey()).append("value", (Object)e.getValue()));
        }
        return contexts;
    }

    private static MutableContextSet docsToContextSet(List<Document> documents) {
        MutableContextSetImpl map = new MutableContextSetImpl();
        for (Document doc : documents) {
            map.add(doc.getString((Object)"key"), doc.getString((Object)"value"));
        }
        return map;
    }
}

