/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.split;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.StorageType;
import me.lucko.luckperms.common.storage.implementation.StorageImplementation;
import me.lucko.luckperms.common.storage.implementation.split.SplitStorageType;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.model.PlayerSaveResult;
import net.luckperms.api.node.Node;

public class SplitStorage
implements StorageImplementation {
    private final LuckPermsPlugin plugin;
    private final Map<StorageType, StorageImplementation> implementations;
    private final Map<SplitStorageType, StorageType> types;

    public SplitStorage(LuckPermsPlugin plugin, Map<StorageType, StorageImplementation> implementations, Map<SplitStorageType, StorageType> types) {
        this.plugin = plugin;
        this.implementations = ImmutableMap.copyOf(implementations);
        this.types = ImmutableMap.copyOf(types);
    }

    public Map<StorageType, StorageImplementation> getImplementations() {
        return this.implementations;
    }

    private StorageImplementation implFor(SplitStorageType type) {
        return this.implementations.get((Object)this.types.get((Object)type));
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return "Split Storage";
    }

    @Override
    public void init() {
        boolean failed = false;
        for (StorageImplementation ds : this.implementations.values()) {
            try {
                ds.init();
            }
            catch (Exception ex) {
                failed = true;
                ex.printStackTrace();
            }
        }
        if (failed) {
            throw new RuntimeException("One of the backings failed to init");
        }
    }

    @Override
    public void shutdown() {
        for (StorageImplementation ds : this.implementations.values()) {
            try {
                ds.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Map<String, String> getMeta() {
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>();
        meta.put("Types", this.types.toString());
        for (StorageImplementation backing : this.implementations.values()) {
            meta.putAll(backing.getMeta());
        }
        return meta;
    }

    @Override
    public void logAction(Action entry) throws Exception {
        this.implFor(SplitStorageType.LOG).logAction(entry);
    }

    @Override
    public Log getLog() throws Exception {
        return this.implFor(SplitStorageType.LOG).getLog();
    }

    @Override
    public void applyBulkUpdate(BulkUpdate bulkUpdate) throws Exception {
        StorageType userType = this.types.get((Object)SplitStorageType.USER);
        StorageType groupType = this.types.get((Object)SplitStorageType.GROUP);
        this.implementations.get((Object)userType).applyBulkUpdate(bulkUpdate);
        if (userType != groupType) {
            this.implementations.get((Object)groupType).applyBulkUpdate(bulkUpdate);
        }
    }

    @Override
    public User loadUser(UUID uniqueId, String username) throws Exception {
        return this.implFor(SplitStorageType.USER).loadUser(uniqueId, username);
    }

    @Override
    public void saveUser(User user) throws Exception {
        this.implFor(SplitStorageType.USER).saveUser(user);
    }

    @Override
    public Set<UUID> getUniqueUsers() throws Exception {
        return this.implFor(SplitStorageType.USER).getUniqueUsers();
    }

    @Override
    public <N extends Node> List<NodeEntry<UUID, N>> getUsersWithPermission(ConstraintNodeMatcher<N> constraint) throws Exception {
        return this.implFor(SplitStorageType.USER).getUsersWithPermission(constraint);
    }

    @Override
    public Group createAndLoadGroup(String name) throws Exception {
        return this.implFor(SplitStorageType.GROUP).createAndLoadGroup(name);
    }

    @Override
    public Optional<Group> loadGroup(String name) throws Exception {
        return this.implFor(SplitStorageType.GROUP).loadGroup(name);
    }

    @Override
    public void loadAllGroups() throws Exception {
        this.implFor(SplitStorageType.GROUP).loadAllGroups();
    }

    @Override
    public void saveGroup(Group group) throws Exception {
        this.implFor(SplitStorageType.GROUP).saveGroup(group);
    }

    @Override
    public void deleteGroup(Group group) throws Exception {
        this.implFor(SplitStorageType.GROUP).deleteGroup(group);
    }

    @Override
    public <N extends Node> List<NodeEntry<String, N>> getGroupsWithPermission(ConstraintNodeMatcher<N> constraint) throws Exception {
        return this.implFor(SplitStorageType.GROUP).getGroupsWithPermission(constraint);
    }

    @Override
    public Track createAndLoadTrack(String name) throws Exception {
        return this.implFor(SplitStorageType.TRACK).createAndLoadTrack(name);
    }

    @Override
    public Optional<Track> loadTrack(String name) throws Exception {
        return this.implFor(SplitStorageType.TRACK).loadTrack(name);
    }

    @Override
    public void loadAllTracks() throws Exception {
        this.implFor(SplitStorageType.TRACK).loadAllTracks();
    }

    @Override
    public void saveTrack(Track track) throws Exception {
        this.implFor(SplitStorageType.TRACK).saveTrack(track);
    }

    @Override
    public void deleteTrack(Track track) throws Exception {
        this.implFor(SplitStorageType.TRACK).deleteTrack(track);
    }

    @Override
    public PlayerSaveResult savePlayerData(UUID uniqueId, String username) throws Exception {
        return this.implFor(SplitStorageType.UUID).savePlayerData(uniqueId, username);
    }

    @Override
    public UUID getPlayerUniqueId(String username) throws Exception {
        return this.implFor(SplitStorageType.UUID).getPlayerUniqueId(username);
    }

    @Override
    public String getPlayerName(UUID uniqueId) throws Exception {
        return this.implFor(SplitStorageType.UUID).getPlayerName(uniqueId);
    }
}

