/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.lucko.luckperms.common.context.ContextSetJsonSerializer;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.node.Node;

public final class SqlNode {
    public static final int NULL_ID = -1;
    private final String permission;
    private final boolean value;
    private final String server;
    private final String world;
    private final long expiry;
    private final ImmutableContextSet contexts;
    private final long sqlId;

    public static SqlNode fromNode(Node node) {
        String world;
        String server;
        ContextSet contexts = node.getContexts();
        Set<String> servers = contexts.getValues("server");
        Optional firstServer = servers.stream().sorted().findFirst();
        if (firstServer.isPresent()) {
            server = (String)firstServer.get();
            MutableContextSet mutableContextSet = contexts.mutableCopy();
            mutableContextSet.remove("server", server);
            contexts = mutableContextSet;
        } else {
            server = "global";
        }
        Set<String> worlds = contexts.getValues("world");
        Optional firstWorld = worlds.stream().sorted().findFirst();
        if (firstWorld.isPresent()) {
            world = (String)firstWorld.get();
            MutableContextSet mutableContextSet = contexts instanceof MutableContextSet ? (MutableContextSet)contexts : contexts.mutableCopy();
            mutableContextSet.remove("world", world);
            contexts = mutableContextSet;
        } else {
            world = "global";
        }
        long expiry = node.hasExpiry() ? node.getExpiry().getEpochSecond() : 0L;
        return new SqlNode(node.getKey(), node.getValue(), server, world, expiry, contexts.immutableCopy(), -1L);
    }

    public static SqlNode fromSqlFields(long sqlId, String permission, boolean value, String server, String world, long expiry, String contexts) {
        return new SqlNode(permission, value, server, world, expiry, ContextSetJsonSerializer.deserializeContextSet(GsonProvider.normal(), contexts).immutableCopy(), sqlId);
    }

    private SqlNode(String permission, boolean value, String server, String world, long expiry, ImmutableContextSet contexts, long sqlId) {
        this.permission = Objects.requireNonNull(permission, "permission");
        this.value = value;
        this.server = Objects.requireNonNull(server, "server");
        this.world = Objects.requireNonNull(world, "world");
        this.expiry = expiry;
        this.contexts = Objects.requireNonNull(contexts, "contexts");
        this.sqlId = sqlId;
    }

    public Node toNode() {
        return NodeBuilders.determineMostApplicable(this.permission).value(this.value).withContext("server", this.server).withContext("world", this.world).expiry(this.expiry).withContext(this.contexts).build();
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean getValue() {
        return this.value;
    }

    public String getServer() {
        return this.server;
    }

    public String getWorld() {
        return this.world;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public ImmutableContextSet getContexts() {
        return this.contexts;
    }

    public long getSqlId() {
        if (this.sqlId == -1L) {
            throw new IllegalStateException("sql id not set");
        }
        return this.sqlId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlNode)) {
            return false;
        }
        SqlNode other = (SqlNode)o;
        return this.getPermission().equals(other.getPermission()) && this.getValue() == other.getValue() && this.getServer().equals(other.getServer()) && this.getWorld().equals(other.getWorld()) && this.getExpiry() == other.getExpiry() && this.getContexts().equals(other.getContexts());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPermission().hashCode();
        result = result * 59 + Boolean.hashCode(this.getValue());
        result = result * 59 + this.getServer().hashCode();
        result = result * 59 + this.getWorld().hashCode();
        result = result * 59 + Long.hashCode(this.getExpiry());
        result = result * 59 + this.getContexts().hashCode();
        return result;
    }

    public String toString() {
        return "NodeModel(permission=" + this.getPermission() + ", value=" + this.getValue() + ", server=" + this.getServer() + ", world=" + this.getWorld() + ", expiry=" + this.getExpiry() + ", contexts=" + this.getContexts() + ")";
    }
}

