/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.bulkupdate.PreparedStatementBuilder;
import me.lucko.luckperms.common.context.ContextSetJsonSerializer;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.StorageImplementation;
import me.lucko.luckperms.common.storage.implementation.sql.SchemaReader;
import me.lucko.luckperms.common.storage.implementation.sql.SqlNode;
import me.lucko.luckperms.common.storage.implementation.sql.connection.ConnectionFactory;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.storage.misc.PlayerSaveResultImpl;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.model.PlayerSaveResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;

public class SqlStorage
implements StorageImplementation {
    private static final Type LIST_STRING_TYPE = new TypeToken<List<String>>(){}.getType();
    private static final String USER_PERMISSIONS_SELECT = "SELECT id, permission, value, server, world, expiry, contexts FROM '{prefix}user_permissions' WHERE uuid=?";
    private static final String USER_PERMISSIONS_DELETE_SPECIFIC = "DELETE FROM '{prefix}user_permissions' WHERE id=?";
    private static final String USER_PERMISSIONS_DELETE = "DELETE FROM '{prefix}user_permissions' WHERE uuid=?";
    private static final String USER_PERMISSIONS_INSERT = "INSERT INTO '{prefix}user_permissions' (uuid, permission, value, server, world, expiry, contexts) VALUES(?, ?, ?, ?, ?, ?, ?)";
    private static final String USER_PERMISSIONS_SELECT_DISTINCT = "SELECT DISTINCT uuid FROM '{prefix}user_permissions'";
    private static final String USER_PERMISSIONS_SELECT_PERMISSION = "SELECT uuid, id, permission, value, server, world, expiry, contexts FROM '{prefix}user_permissions' WHERE ";
    private static final String PLAYER_SELECT_UUID_BY_USERNAME = "SELECT uuid FROM '{prefix}players' WHERE username=? LIMIT 1";
    private static final String PLAYER_SELECT_USERNAME_BY_UUID = "SELECT username FROM '{prefix}players' WHERE uuid=? LIMIT 1";
    private static final String PLAYER_UPDATE_USERNAME_FOR_UUID = "UPDATE '{prefix}players' SET username=? WHERE uuid=?";
    private static final String PLAYER_INSERT = "INSERT INTO '{prefix}players' (uuid, username, primary_group) VALUES(?, ?, ?)";
    private static final String PLAYER_SELECT_ALL_UUIDS_BY_USERNAME = "SELECT uuid FROM '{prefix}players' WHERE username=? AND NOT uuid=?";
    private static final String PLAYER_DELETE_ALL_UUIDS_BY_USERNAME = "DELETE FROM '{prefix}players' WHERE username=? AND NOT uuid=?";
    private static final String PLAYER_SELECT_BY_UUID = "SELECT username, primary_group FROM '{prefix}players' WHERE uuid=?";
    private static final String PLAYER_SELECT_PRIMARY_GROUP_BY_UUID = "SELECT primary_group FROM '{prefix}players' WHERE uuid=? LIMIT 1";
    private static final String PLAYER_UPDATE_PRIMARY_GROUP_BY_UUID = "UPDATE '{prefix}players' SET primary_group=? WHERE uuid=?";
    private static final String GROUP_PERMISSIONS_SELECT = "SELECT id, permission, value, server, world, expiry, contexts FROM '{prefix}group_permissions' WHERE name=?";
    private static final String GROUP_PERMISSIONS_SELECT_ALL = "SELECT name, id, permission, value, server, world, expiry, contexts FROM '{prefix}group_permissions'";
    private static final String GROUP_PERMISSIONS_DELETE_SPECIFIC = "DELETE FROM '{prefix}group_permissions' WHERE id=?";
    private static final String GROUP_PERMISSIONS_DELETE = "DELETE FROM '{prefix}group_permissions' WHERE name=?";
    private static final String GROUP_PERMISSIONS_INSERT = "INSERT INTO '{prefix}group_permissions' (name, permission, value, server, world, expiry, contexts) VALUES(?, ?, ?, ?, ?, ?, ?)";
    private static final String GROUP_PERMISSIONS_SELECT_PERMISSION = "SELECT name, id, permission, value, server, world, expiry, contexts FROM '{prefix}group_permissions' WHERE ";
    private static final String GROUP_SELECT_ALL = "SELECT name FROM '{prefix}groups'";
    private static final Map<String, String> GROUP_INSERT = ImmutableMap.of((Object)"H2", (Object)"MERGE INTO '{prefix}groups' (name) VALUES(?)", (Object)"SQLite", (Object)"INSERT OR IGNORE INTO '{prefix}groups' (name) VALUES(?)", (Object)"PostgreSQL", (Object)"INSERT INTO '{prefix}groups' (name) VALUES(?) ON CONFLICT (name) DO NOTHING");
    private static final String GROUP_INSERT_DEFAULT = "INSERT INTO '{prefix}groups' (name) VALUES(?) ON DUPLICATE KEY UPDATE name=name";
    private static final String GROUP_DELETE = "DELETE FROM '{prefix}groups' WHERE name=?";
    private static final String TRACK_INSERT = "INSERT INTO '{prefix}tracks' (name, 'groups') VALUES(?, ?)";
    private static final String TRACK_SELECT = "SELECT 'groups' FROM '{prefix}tracks' WHERE name=?";
    private static final String TRACK_SELECT_ALL = "SELECT * FROM '{prefix}tracks'";
    private static final String TRACK_UPDATE = "UPDATE '{prefix}tracks' SET 'groups'=? WHERE name=?";
    private static final String TRACK_DELETE = "DELETE FROM '{prefix}tracks' WHERE name=?";
    private static final String ACTION_INSERT = "INSERT INTO '{prefix}actions' (time, actor_uuid, actor_name, type, acted_uuid, acted_name, action) VALUES(?, ?, ?, ?, ?, ?, ?)";
    private static final String ACTION_SELECT_ALL = "SELECT * FROM '{prefix}actions'";
    private final LuckPermsPlugin plugin;
    private final ConnectionFactory connectionFactory;
    private final Function<String, String> statementProcessor;

    public SqlStorage(LuckPermsPlugin plugin, ConnectionFactory connectionFactory, String tablePrefix) {
        this.plugin = plugin;
        this.connectionFactory = connectionFactory;
        this.statementProcessor = connectionFactory.getStatementProcessor().compose(s -> s.replace("{prefix}", tablePrefix));
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return this.connectionFactory.getImplementationName();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Function<String, String> getStatementProcessor() {
        return this.statementProcessor;
    }

    @Override
    public void init() throws Exception {
        boolean tableExists;
        this.connectionFactory.init(this.plugin);
        try (Connection c = this.connectionFactory.getConnection();){
            tableExists = SqlStorage.tableExists(c, this.statementProcessor.apply("{prefix}user_permissions"));
        }
        if (!tableExists) {
            this.applySchema();
        }
    }

    private void applySchema() throws IOException, SQLException {
        block56: {
            List statements;
            String schemaFileName = "me/lucko/luckperms/schema/" + this.connectionFactory.getImplementationName().toLowerCase() + ".sql";
            try (InputStream is = this.plugin.getBootstrap().getResourceStream(schemaFileName);){
                if (is == null) {
                    throw new IOException("Couldn't locate schema file for " + this.connectionFactory.getImplementationName());
                }
                statements = SchemaReader.getStatements(is).stream().map(this.statementProcessor).collect(Collectors.toList());
            }
            var4_3 = null;
            try (Connection connection = this.connectionFactory.getConnection();){
                Throwable throwable;
                Statement s;
                boolean utf8mb4Unsupported;
                block55: {
                    utf8mb4Unsupported = false;
                    s = connection.createStatement();
                    throwable = null;
                    try {
                        for (String query : statements) {
                            s.addBatch(query);
                        }
                        try {
                            s.executeBatch();
                        }
                        catch (BatchUpdateException e) {
                            if (e.getMessage().contains("Unknown character set")) {
                                utf8mb4Unsupported = true;
                                break block55;
                            }
                            throw e;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (s != null) {
                            if (throwable != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                s.close();
                            }
                        }
                    }
                }
                if (!utf8mb4Unsupported) break block56;
                s = connection.createStatement();
                throwable = null;
                try {
                    for (String query : statements) {
                        s.addBatch(query.replace("utf8mb4", "utf8"));
                    }
                    s.executeBatch();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (s != null) {
                        if (throwable != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            s.close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                var4_3 = throwable;
                throw throwable;
            }
        }
    }

    @Override
    public void shutdown() {
        try {
            this.connectionFactory.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, String> getMeta() {
        return this.connectionFactory.getMeta();
    }

    @Override
    public void logAction(Action entry) throws SQLException {
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(ACTION_INSERT));){
            SqlStorage.writeAction(entry, ps);
            ps.execute();
        }
    }

    @Override
    public Log getLog() throws SQLException {
        Log.Builder log = Log.builder();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(ACTION_SELECT_ALL));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                log.add(SqlStorage.readAction(rs));
            }
        }
        return log.build();
    }

    @Override
    public void applyBulkUpdate(BulkUpdate bulkUpdate) throws SQLException {
        block38: {
            try (Connection c = this.connectionFactory.getConnection();){
                Throwable throwable;
                PreparedStatement ps;
                String table;
                if (bulkUpdate.getDataType().isIncludingUsers()) {
                    table = this.statementProcessor.apply("{prefix}user_permissions");
                    ps = bulkUpdate.buildAsSql().build(c, q -> q.replace("{table}", table));
                    throwable = null;
                    try {
                        ps.execute();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ps != null) {
                            if (throwable != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ps.close();
                            }
                        }
                    }
                }
                if (!bulkUpdate.getDataType().isIncludingGroups()) break block38;
                table = this.statementProcessor.apply("{prefix}group_permissions");
                ps = bulkUpdate.buildAsSql().build(c, q -> q.replace("{table}", table));
                throwable = null;
                try {
                    ps.execute();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (ps != null) {
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User loadUser(UUID uniqueId, String username) throws SQLException {
        User user = this.plugin.getUserManager().getOrMake(uniqueId, username);
        user.getIoLock().lock();
        try {
            List nodes;
            String primaryGroup = null;
            String savedUsername = null;
            try (Connection c = this.connectionFactory.getConnection();){
                nodes = this.selectUserPermissions(new ArrayList(), c, user.getUniqueId());
                SqlPlayerData playerData = this.selectPlayerData(c, user.getUniqueId());
                if (playerData != null) {
                    primaryGroup = playerData.primaryGroup;
                    savedUsername = playerData.username;
                }
            }
            if (primaryGroup == null) {
                primaryGroup = "default";
            }
            user.getPrimaryGroup().setStoredValue(primaryGroup);
            user.setUsername(savedUsername, true);
            if (!nodes.isEmpty()) {
                user.setNodes(DataType.NORMAL, nodes.stream().map(SqlNode::toNode));
                if (this.plugin.getUserManager().giveDefaultIfNeeded(user, false) | user.auditTemporaryNodes()) {
                    this.saveUser(user);
                }
            } else if (this.plugin.getUserManager().shouldSave(user)) {
                user.clearNodes(DataType.NORMAL, null, true);
                user.getPrimaryGroup().setStoredValue(null);
                this.plugin.getUserManager().giveDefaultIfNeeded(user, false);
            }
        }
        finally {
            user.getIoLock().unlock();
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUser(User user) throws SQLException {
        user.getIoLock().lock();
        try {
            Set remote;
            if (!this.plugin.getUserManager().shouldSave(user)) {
                try (Connection c = this.connectionFactory.getConnection();){
                    this.deleteUser(c, user.getUniqueId());
                }
                return;
            }
            try (Connection c = this.connectionFactory.getConnection();){
                remote = this.selectUserPermissions(new HashSet(), c, user.getUniqueId());
            }
            Set<SqlNode> local = user.normalData().immutable().values().stream().map(SqlNode::fromNode).collect(Collectors.toSet());
            Set<SqlNode> missingFromRemote = SqlStorage.getMissingFromRemote(local, remote);
            Set<SqlNode> missingFromLocal = SqlStorage.getMissingFromLocal(local, remote);
            try (Connection c = this.connectionFactory.getConnection();){
                this.updateUserPermissions(c, user.getUniqueId(), missingFromRemote, missingFromLocal);
                this.insertPlayerData(c, user.getUniqueId(), new SqlPlayerData(user.getPrimaryGroup().getStoredValue().orElse("default"), user.getUsername().orElse("null").toLowerCase()));
            }
        }
        finally {
            user.getIoLock().unlock();
        }
    }

    @Override
    public Set<UUID> getUniqueUsers() throws SQLException {
        HashSet<UUID> uuids = new HashSet<UUID>();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(USER_PERMISSIONS_SELECT_DISTINCT));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String uuid = rs.getString("uuid");
                uuids.add(UUID.fromString(uuid));
            }
        }
        return uuids;
    }

    @Override
    public <N extends Node> List<NodeEntry<UUID, N>> getUsersWithPermission(ConstraintNodeMatcher<N> constraint) throws SQLException {
        PreparedStatementBuilder builder = new PreparedStatementBuilder().append(USER_PERMISSIONS_SELECT_PERMISSION);
        constraint.getConstraint().appendSql(builder, "permission");
        ArrayList<NodeEntry<UUID, N>> held = new ArrayList<NodeEntry<UUID, N>>();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = builder.build(c, this.statementProcessor);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                UUID holder = UUID.fromString(rs.getString("uuid"));
                Node node = SqlStorage.readNode(rs).toNode();
                N match = constraint.filterConstraintMatch(node);
                if (match == null) continue;
                held.add(NodeEntry.of(holder, match));
            }
        }
        return held;
    }

    @Override
    public Group createAndLoadGroup(String name) throws SQLException {
        String query = GROUP_INSERT.getOrDefault(this.connectionFactory.getImplementationName(), GROUP_INSERT_DEFAULT);
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(query));){
            ps.setString(1, name);
            ps.execute();
        }
        return this.loadGroup(name).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Group> loadGroup(String name) throws SQLException {
        Set<String> groups;
        try (Connection c = this.connectionFactory.getConnection();){
            groups = this.selectGroups(c);
        }
        if (!groups.contains(name)) {
            return Optional.empty();
        }
        Group group = (Group)this.plugin.getGroupManager().getOrMake(name);
        group.getIoLock().lock();
        try {
            List nodes;
            try (Connection c = this.connectionFactory.getConnection();){
                nodes = this.selectGroupPermissions(new ArrayList(), c, group.getName());
            }
            if (!nodes.isEmpty()) {
                group.setNodes(DataType.NORMAL, nodes.stream().map(SqlNode::toNode));
            } else {
                group.clearNodes(DataType.NORMAL, null, false);
            }
        }
        finally {
            group.getIoLock().unlock();
        }
        return Optional.of(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadAllGroups() throws SQLException {
        HashMap<String, Collection<SqlNode>> groups = new HashMap<String, Collection<SqlNode>>();
        try (Connection c = this.connectionFactory.getConnection();){
            this.selectGroups(c).forEach(name -> {
                Collection cfr_ignored_0 = groups.put((String)name, new ArrayList());
            });
            this.selectAllGroupPermissions(groups, c);
        }
        for (Map.Entry entry : groups.entrySet()) {
            Group group = (Group)this.plugin.getGroupManager().getOrMake(entry.getKey());
            group.getIoLock().lock();
            try {
                Collection nodes = (Collection)entry.getValue();
                if (!nodes.isEmpty()) {
                    group.setNodes(DataType.NORMAL, nodes.stream().map(SqlNode::toNode));
                    continue;
                }
                group.clearNodes(DataType.NORMAL, null, false);
            }
            finally {
                group.getIoLock().unlock();
            }
        }
        this.plugin.getGroupManager().retainAll(groups.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveGroup(Group group) throws SQLException {
        block43: {
            group.getIoLock().lock();
            try {
                Set remote;
                if (group.normalData().immutable().isEmpty()) {
                    try (Connection c = this.connectionFactory.getConnection();){
                        this.deleteGroupPermissions(c, group.getName());
                    }
                    return;
                }
                try (Connection c = this.connectionFactory.getConnection();){
                    remote = this.selectGroupPermissions(new HashSet(), c, group.getName());
                }
                Set<SqlNode> local = group.normalData().immutable().values().stream().map(SqlNode::fromNode).collect(Collectors.toSet());
                Set<SqlNode> missingFromRemote = SqlStorage.getMissingFromRemote(local, remote);
                Set<SqlNode> missingFromLocal = SqlStorage.getMissingFromLocal(local, remote);
                if (missingFromLocal.isEmpty() && missingFromRemote.isEmpty()) break block43;
                try (Connection c = this.connectionFactory.getConnection();){
                    this.updateGroupPermissions(c, group.getName(), missingFromRemote, missingFromLocal);
                }
            }
            finally {
                group.getIoLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteGroup(Group group) throws SQLException {
        group.getIoLock().lock();
        try (Connection c = this.connectionFactory.getConnection();){
            this.deleteGroupPermissions(c, group.getName());
            try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(GROUP_DELETE));){
                ps.setString(1, group.getName());
                ps.execute();
            }
        }
        finally {
            group.getIoLock().unlock();
        }
        this.plugin.getGroupManager().unload(group.getName());
    }

    @Override
    public <N extends Node> List<NodeEntry<String, N>> getGroupsWithPermission(ConstraintNodeMatcher<N> constraint) throws SQLException {
        PreparedStatementBuilder builder = new PreparedStatementBuilder().append(GROUP_PERMISSIONS_SELECT_PERMISSION);
        constraint.getConstraint().appendSql(builder, "permission");
        ArrayList<NodeEntry<String, N>> held = new ArrayList<NodeEntry<String, N>>();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = builder.build(c, this.statementProcessor);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String holder = rs.getString("name");
                Node node = SqlStorage.readNode(rs).toNode();
                N match = constraint.filterConstraintMatch(node);
                if (match == null) continue;
                held.add(NodeEntry.of(holder, match));
            }
        }
        return held;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Track createAndLoadTrack(String name) throws SQLException {
        Track track;
        block29: {
            track = (Track)this.plugin.getTrackManager().getOrMake(name);
            track.getIoLock().lock();
            try {
                List<String> groups;
                try (Connection c = this.connectionFactory.getConnection();){
                    groups = this.selectTrack(c, track.getName());
                }
                if (groups != null) {
                    track.setGroups(groups);
                    break block29;
                }
                c = this.connectionFactory.getConnection();
                var5_4 = null;
                try {
                    this.insertTrack(c, track.getName(), track.getGroups());
                }
                catch (Throwable throwable) {
                    var5_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (c != null) {
                        if (var5_4 != null) {
                            try {
                                c.close();
                            }
                            catch (Throwable throwable) {
                                var5_4.addSuppressed(throwable);
                            }
                        } else {
                            c.close();
                        }
                    }
                }
            }
            finally {
                track.getIoLock().unlock();
            }
        }
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Track> loadTrack(String name) throws SQLException {
        Set<String> tracks;
        try (Connection c = this.connectionFactory.getConnection();){
            tracks = this.selectTracks(c);
        }
        if (!tracks.contains(name)) {
            return Optional.empty();
        }
        Track track = (Track)this.plugin.getTrackManager().getOrMake(name);
        track.getIoLock().lock();
        try {
            List<String> groups;
            try (Connection c = this.connectionFactory.getConnection();){
                groups = this.selectTrack(c, name);
            }
            track.setGroups(groups);
        }
        finally {
            track.getIoLock().unlock();
        }
        return Optional.of(track);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadAllTracks() throws SQLException {
        Set<String> tracks;
        try (Connection c = this.connectionFactory.getConnection();){
            tracks = this.selectTracks(c);
            for (String trackName : tracks) {
                Track track = (Track)this.plugin.getTrackManager().getOrMake(trackName);
                track.getIoLock().lock();
                try {
                    List<String> groups = this.selectTrack(c, trackName);
                    track.setGroups(groups);
                }
                finally {
                    track.getIoLock().unlock();
                }
            }
        }
        this.plugin.getTrackManager().retainAll(tracks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTrack(Track track) throws SQLException {
        track.getIoLock().lock();
        try (Connection c = this.connectionFactory.getConnection();){
            this.updateTrack(c, track.getName(), track.getGroups());
        }
        finally {
            track.getIoLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTrack(Track track) throws SQLException {
        track.getIoLock().lock();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(TRACK_DELETE));){
            ps.setString(1, track.getName());
            ps.execute();
        }
        finally {
            track.getIoLock().unlock();
        }
        this.plugin.getTrackManager().unload(track.getName());
    }

    @Override
    public PlayerSaveResult savePlayerData(UUID uniqueId, String username) throws SQLException {
        Throwable throwable;
        PreparedStatement ps3;
        Throwable throwable2;
        String oldUsername;
        block100: {
            if (!(username = username.toLowerCase()).equals(oldUsername = this.getPlayerName(uniqueId))) {
                try (Connection c = this.connectionFactory.getConnection();){
                    PreparedStatement ps2;
                    if (oldUsername != null) {
                        ps2 = c.prepareStatement(this.statementProcessor.apply(PLAYER_UPDATE_USERNAME_FOR_UUID));
                        throwable2 = null;
                        try {
                            ps2.setString(1, username);
                            ps2.setString(2, uniqueId.toString());
                            ps2.execute();
                            break block100;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (ps2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        ps2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                } else {
                                    ps2.close();
                                }
                            }
                        }
                    }
                    ps2 = c.prepareStatement(this.statementProcessor.apply(PLAYER_INSERT));
                    throwable2 = null;
                    try {
                        ps2.setString(1, uniqueId.toString());
                        ps2.setString(2, username);
                        ps2.setString(3, "default");
                        ps2.execute();
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ps2 != null) {
                            if (throwable2 != null) {
                                try {
                                    ps2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                ps2.close();
                            }
                        }
                    }
                }
            }
        }
        PlayerSaveResultImpl result = PlayerSaveResultImpl.determineBaseResult(username, oldUsername);
        HashSet<UUID> conflicting = new HashSet<UUID>();
        throwable2 = null;
        try (Connection c = this.connectionFactory.getConnection();){
            ps3 = c.prepareStatement(this.statementProcessor.apply(PLAYER_SELECT_ALL_UUIDS_BY_USERNAME));
            throwable = null;
            try {
                ps3.setString(1, username);
                ps3.setString(2, uniqueId.toString());
                try (ResultSet rs = ps3.executeQuery();){
                    while (rs.next()) {
                        conflicting.add(UUID.fromString(rs.getString("uuid")));
                    }
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (ps3 != null) {
                    if (throwable != null) {
                        try {
                            ps3.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        ps3.close();
                    }
                }
            }
        }
        catch (Throwable ps3) {
            throwable2 = ps3;
            throw ps3;
        }
        if (!conflicting.isEmpty()) {
            c = this.connectionFactory.getConnection();
            throwable2 = null;
            try {
                ps3 = c.prepareStatement(this.statementProcessor.apply(PLAYER_DELETE_ALL_UUIDS_BY_USERNAME));
                throwable = null;
                try {
                    ps3.setString(1, username);
                    ps3.setString(2, uniqueId.toString());
                    ps3.execute();
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
                finally {
                    if (ps3 != null) {
                        if (throwable != null) {
                            try {
                                ps3.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            ps3.close();
                        }
                    }
                }
            }
            catch (Throwable throwable11) {
                throwable2 = throwable11;
                throw throwable11;
            }
            finally {
                if (c != null) {
                    if (throwable2 != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable12) {
                            throwable2.addSuppressed(throwable12);
                        }
                    } else {
                        c.close();
                    }
                }
            }
            result = result.withOtherUuidsPresent(conflicting);
        }
        return result;
    }

    @Override
    public UUID getPlayerUniqueId(String username) throws SQLException {
        username = username.toLowerCase();
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_SELECT_UUID_BY_USERNAME));){
            ps.setString(1, username);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    UUID uUID = UUID.fromString(rs.getString("uuid"));
                    return uUID;
                }
            }
        }
        return null;
    }

    @Override
    public String getPlayerName(UUID uniqueId) throws SQLException {
        try (Connection c = this.connectionFactory.getConnection();
             PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_SELECT_USERNAME_BY_UUID));){
            ps.setString(1, uniqueId.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    String string = rs.getString("username");
                    return string;
                }
            }
        }
        return null;
    }

    private static void writeAction(Action action, PreparedStatement ps) throws SQLException {
        ps.setLong(1, action.getTimestamp().getEpochSecond());
        ps.setString(2, action.getSource().getUniqueId().toString());
        ps.setString(3, action.getSource().getName());
        ps.setString(4, Character.toString(LoggedAction.getTypeCharacter(action.getTarget().getType())));
        ps.setString(5, action.getTarget().getUniqueId().map(UUID::toString).orElse("null"));
        ps.setString(6, action.getTarget().getName());
        ps.setString(7, action.getDescription());
    }

    private static LoggedAction readAction(ResultSet rs) throws SQLException {
        String actedUuid = rs.getString("acted_uuid");
        return LoggedAction.build().timestamp(Instant.ofEpochSecond(rs.getLong("time"))).source(UUID.fromString(rs.getString("actor_uuid"))).sourceName(rs.getString("actor_name")).targetType(LoggedAction.parseTypeCharacter(rs.getString("type").toCharArray()[0])).target(actedUuid.equals("null") ? null : UUID.fromString(actedUuid)).targetName(rs.getString("acted_name")).description(rs.getString("action")).build();
    }

    private static SqlNode readNode(ResultSet rs) throws SQLException {
        long id = rs.getLong("id");
        String permission = rs.getString("permission");
        boolean value = rs.getBoolean("value");
        String server = rs.getString("server");
        String world = rs.getString("world");
        long expiry = rs.getLong("expiry");
        String contexts = rs.getString("contexts");
        return SqlNode.fromSqlFields(id, permission, value, server, world, expiry, contexts);
    }

    private static void writeNode(SqlNode nd, PreparedStatement ps) throws SQLException {
        ps.setString(2, nd.getPermission());
        ps.setBoolean(3, nd.getValue());
        ps.setString(4, nd.getServer());
        ps.setString(5, nd.getWorld());
        ps.setLong(6, nd.getExpiry());
        ps.setString(7, GsonProvider.normal().toJson((JsonElement)ContextSetJsonSerializer.serializeContextSet(nd.getContexts())));
    }

    private static Set<SqlNode> getMissingFromRemote(Set<SqlNode> local, Set<SqlNode> remote) {
        HashSet<SqlNode> missingFromRemote = new HashSet<SqlNode>(local);
        missingFromRemote.removeAll(remote);
        return missingFromRemote;
    }

    private static Set<SqlNode> getMissingFromLocal(Set<SqlNode> local, Set<SqlNode> remote) {
        HashSet<SqlNode> missingFromLocal = new HashSet<SqlNode>(remote);
        missingFromLocal.removeAll(local);
        return missingFromLocal;
    }

    private <T extends Collection<SqlNode>> T selectUserPermissions(T nodes, Connection c, UUID user) throws SQLException {
        try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(USER_PERMISSIONS_SELECT));){
            ps.setString(1, user.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    nodes.add((SqlNode)SqlStorage.readNode(rs));
                }
            }
        }
        return nodes;
    }

    /*
     * Exception decompiling
     */
    private SqlPlayerData selectPlayerData(Connection c, UUID user) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteUser(Connection c, UUID user) throws SQLException {
        try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(USER_PERMISSIONS_DELETE));){
            ps.setString(1, user.toString());
            ps.execute();
        }
        ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_UPDATE_PRIMARY_GROUP_BY_UUID));
        var4_4 = null;
        try {
            ps.setString(1, "default");
            ps.setString(2, user.toString());
            ps.execute();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (ps != null) {
                if (var4_4 != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    ps.close();
                }
            }
        }
    }

    private void updateUserPermissions(Connection c, UUID user, Set<SqlNode> add, Set<SqlNode> delete) throws SQLException {
        Throwable throwable;
        PreparedStatement ps;
        if (!delete.isEmpty()) {
            ps = c.prepareStatement(this.statementProcessor.apply(USER_PERMISSIONS_DELETE_SPECIFIC));
            throwable = null;
            try {
                for (SqlNode node : delete) {
                    ps.setLong(1, node.getSqlId());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ps != null) {
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        if (!add.isEmpty()) {
            ps = c.prepareStatement(this.statementProcessor.apply(USER_PERMISSIONS_INSERT));
            throwable = null;
            try {
                for (SqlNode node : add) {
                    ps.setString(1, user.toString());
                    SqlStorage.writeNode(node, ps);
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ps != null) {
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
    }

    private void insertPlayerData(Connection c, UUID user, SqlPlayerData data) throws SQLException {
        boolean hasPrimaryGroupSaved;
        try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_SELECT_PRIMARY_GROUP_BY_UUID));){
            ps.setString(1, user.toString());
            try (ResultSet rs = ps.executeQuery();){
                hasPrimaryGroupSaved = rs.next();
            }
        }
        if (hasPrimaryGroupSaved) {
            ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_UPDATE_PRIMARY_GROUP_BY_UUID));
            var6_5 = null;
            try {
                ps.setString(1, data.primaryGroup);
                ps.setString(2, user.toString());
                ps.execute();
            }
            catch (Throwable throwable) {
                var6_5 = throwable;
                throw throwable;
            }
            finally {
                if (ps != null) {
                    if (var6_5 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {
                            var6_5.addSuppressed(throwable);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        ps = c.prepareStatement(this.statementProcessor.apply(PLAYER_INSERT));
        var6_5 = null;
        try {
            ps.setString(1, user.toString());
            ps.setString(2, data.username);
            ps.setString(3, data.primaryGroup);
            ps.execute();
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (ps != null) {
                if (var6_5 != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable throwable) {
                        var6_5.addSuppressed(throwable);
                    }
                } else {
                    ps.close();
                }
            }
        }
    }

    private Set<String> selectGroups(Connection c) throws SQLException {
        HashSet<String> groups = new HashSet<String>();
        try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(GROUP_SELECT_ALL));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                groups.add(rs.getString("name").toLowerCase());
            }
        }
        return groups;
    }

    private <T extends Collection<SqlNode>> T selectGroupPermissions(T nodes, Connection c, String group) throws SQLException {
        try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(GROUP_PERMISSIONS_SELECT));){
            ps.setString(1, group);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    nodes.add((SqlNode)SqlStorage.readNode(rs));
                }
            }
        }
        return nodes;
    }

    private void selectAllGroupPermissions(Map<String, Collection<SqlNode>> nodes, Connection c) throws SQLException {
        try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(GROUP_PERMISSIONS_SELECT_ALL));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String holder = rs.getString("name");
                Collection<SqlNode> list = nodes.get(holder);
                if (list == null) continue;
                list.add(SqlStorage.readNode(rs));
            }
        }
    }

    private void deleteGroupPermissions(Connection c, String group) throws SQLException {
        try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(GROUP_PERMISSIONS_DELETE));){
            ps.setString(1, group);
            ps.execute();
        }
    }

    private void updateGroupPermissions(Connection c, String group, Set<SqlNode> add, Set<SqlNode> delete) throws SQLException {
        Throwable throwable;
        PreparedStatement ps;
        if (!delete.isEmpty()) {
            ps = c.prepareStatement(this.statementProcessor.apply(GROUP_PERMISSIONS_DELETE_SPECIFIC));
            throwable = null;
            try {
                for (SqlNode node : delete) {
                    ps.setLong(1, node.getSqlId());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ps != null) {
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        if (!add.isEmpty()) {
            ps = c.prepareStatement(this.statementProcessor.apply(GROUP_PERMISSIONS_INSERT));
            throwable = null;
            try {
                for (SqlNode node : add) {
                    ps.setString(1, group);
                    SqlStorage.writeNode(node, ps);
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ps != null) {
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
    }

    private List<String> selectTrack(Connection c, String name) throws SQLException {
        String groups;
        try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(TRACK_SELECT));){
            ps.setString(1, name);
            try (ResultSet rs = ps.executeQuery();){
                groups = rs.next() ? rs.getString("groups") : null;
            }
        }
        return groups == null ? null : (List)GsonProvider.normal().fromJson(groups, LIST_STRING_TYPE);
    }

    private void insertTrack(Connection c, String name, List<String> groups) throws SQLException {
        String json = GsonProvider.normal().toJson(groups);
        try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(TRACK_INSERT));){
            ps.setString(1, name);
            ps.setString(2, json);
            ps.execute();
        }
    }

    private void updateTrack(Connection c, String name, List<String> groups) throws SQLException {
        String json = GsonProvider.normal().toJson(groups);
        try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(TRACK_UPDATE));){
            ps.setString(1, json);
            ps.setString(2, name);
            ps.execute();
        }
    }

    private Set<String> selectTracks(Connection c) throws SQLException {
        HashSet<String> tracks = new HashSet<String>();
        try (PreparedStatement ps = c.prepareStatement(this.statementProcessor.apply(TRACK_SELECT_ALL));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                tracks.add(rs.getString("name").toLowerCase());
            }
        }
        return tracks;
    }

    private static boolean tableExists(Connection connection, String table) throws SQLException {
        try (ResultSet rs = connection.getMetaData().getTables(null, null, "%", null);){
            while (rs.next()) {
                if (!rs.getString(3).equalsIgnoreCase(table)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static final class SqlPlayerData {
        private final String primaryGroup;
        private final String username;

        SqlPlayerData(String primaryGroup, String username) {
            this.primaryGroup = primaryGroup;
            this.username = username;
        }
    }
}

