/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.hikari;

import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.plugin.logging.PluginLogger;
import me.lucko.luckperms.common.storage.implementation.sql.connection.ConnectionFactory;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.lib.hikari.HikariConfig;
import me.lucko.luckperms.lib.hikari.HikariDataSource;

public abstract class HikariConnectionFactory
implements ConnectionFactory {
    protected final StorageCredentials configuration;
    private HikariDataSource hikari;

    public HikariConnectionFactory(StorageCredentials configuration) {
        this.configuration = configuration;
    }

    protected String getDriverClass() {
        return null;
    }

    protected void appendProperties(HikariConfig config, Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            config.addDataSourceProperty(property.getKey(), (Object)property.getValue());
        }
    }

    protected void appendConfigurationInfo(HikariConfig config) {
        String address = this.configuration.getAddress();
        String[] addressSplit = address.split(":");
        address = addressSplit[0];
        String port = addressSplit.length > 1 ? addressSplit[1] : "3306";
        config.setDataSourceClassName(this.getDriverClass());
        config.addDataSourceProperty("serverName", (Object)address);
        config.addDataSourceProperty("port", (Object)port);
        config.addDataSourceProperty("databaseName", (Object)this.configuration.getDatabase());
        config.setUsername(this.configuration.getUsername());
        config.setPassword(this.configuration.getPassword());
    }

    @Override
    public void init(LuckPermsPlugin plugin) {
        HikariConfig config;
        try {
            config = new HikariConfig();
        }
        catch (LinkageError e) {
            HikariConnectionFactory.handleLinkageError(e, plugin);
            throw e;
        }
        config.setPoolName("luckperms-hikari");
        this.appendConfigurationInfo(config);
        HashMap<String, String> properties = new HashMap<String, String>(this.configuration.getProperties());
        properties.putIfAbsent("socketTimeout", String.valueOf(TimeUnit.SECONDS.toMillis(30L)));
        this.appendProperties(config, properties);
        config.setMaximumPoolSize(this.configuration.getMaxPoolSize());
        config.setMinimumIdle(this.configuration.getMinIdleConnections());
        config.setMaxLifetime((long)this.configuration.getMaxLifetime());
        config.setConnectionTimeout((long)this.configuration.getConnectionTimeout());
        config.setInitializationFailTimeout(-1L);
        this.hikari = new HikariDataSource(config);
    }

    @Override
    public void shutdown() {
        if (this.hikari != null) {
            this.hikari.close();
        }
    }

    @Override
    public Map<String, String> getMeta() {
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>();
        boolean success = true;
        long start = System.currentTimeMillis();
        try (Connection c = this.getConnection();
             Statement s = c.createStatement();){
            s.execute("/* ping */ SELECT 1");
        }
        catch (SQLException e) {
            success = false;
        }
        long duration = System.currentTimeMillis() - start;
        if (success) {
            meta.put("Ping", "&a" + duration + "ms");
            meta.put("Connected", "true");
        } else {
            meta.put("Connected", "false");
        }
        return meta;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.hikari == null) {
            throw new SQLException("Unable to get a connection from the pool. (hikari is null)");
        }
        Connection connection = this.hikari.getConnection();
        if (connection == null) {
            throw new SQLException("Unable to get a connection from the pool. (getConnection returned null)");
        }
        return connection;
    }

    private static void handleLinkageError(LinkageError linkageError, LuckPermsPlugin plugin) {
        ImmutableList noteworthyClasses = ImmutableList.of((Object)"org.slf4j.LoggerFactory", (Object)"org.slf4j.ILoggerFactory", (Object)"org.apache.logging.slf4j.Log4jLoggerFactory", (Object)"org.apache.logging.log4j.spi.LoggerContext", (Object)"org.apache.logging.log4j.spi.AbstractLoggerAdapter", (Object)"org.slf4j.impl.StaticLoggerBinder");
        PluginLogger logger = plugin.getLogger();
        logger.warn("A " + linkageError.getClass().getSimpleName() + " has occurred whilst initialising Hikari. This is likely due to classloading conflicts between other plugins.");
        logger.warn("Please check for other plugins below (and try loading LuckPerms without them installed) before reporting the issue.");
        for (String className : noteworthyClasses) {
            String loaderName;
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (Exception ex) {
                continue;
            }
            ClassLoader loader = clazz.getClassLoader();
            try {
                loaderName = plugin.getBootstrap().identifyClassLoader(loader) + " (" + loader.toString() + ")";
            }
            catch (Exception e) {
                loaderName = loader.toString();
            }
            logger.warn("Class " + className + " has been loaded by: " + loaderName);
        }
    }
}

