/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.hikari;

import java.util.Map;
import java.util.function.Function;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.HikariConnectionFactory;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.lib.hikari.HikariConfig;

public class PostgreConnectionFactory
extends HikariConnectionFactory {
    public PostgreConnectionFactory(StorageCredentials configuration) {
        super(configuration);
    }

    @Override
    public String getImplementationName() {
        return "PostgreSQL";
    }

    @Override
    protected void appendProperties(HikariConfig config, Map<String, String> properties) {
        properties.remove("useUnicode");
        properties.remove("characterEncoding");
        super.appendProperties(config, properties);
    }

    @Override
    protected void appendConfigurationInfo(HikariConfig config) {
        String address = this.configuration.getAddress();
        String[] addressSplit = address.split(":");
        address = addressSplit[0];
        String port = addressSplit.length > 1 ? addressSplit[1] : "5432";
        String database = this.configuration.getDatabase();
        String username = this.configuration.getUsername();
        String password = this.configuration.getPassword();
        config.setDataSourceClassName("me.lucko.luckperms.lib.postgresql.ds.PGSimpleDataSource");
        config.addDataSourceProperty("serverName", (Object)address);
        config.addDataSourceProperty("portNumber", (Object)port);
        config.addDataSourceProperty("databaseName", (Object)database);
        config.addDataSourceProperty("user", (Object)username);
        config.addDataSourceProperty("password", (Object)password);
    }

    @Override
    public Function<String, String> getStatementProcessor() {
        return s -> s.replace("'", "\"");
    }
}

