/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.treeview;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.luckperms.common.treeview.ImmutableTreeNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TreeNode {
    private Map<String, TreeNode> children = null;
    private final int level;
    private final TreeNode parent;
    private int cachedDeepSize = Integer.MIN_VALUE;

    private static boolean allowInsert(TreeNode node) {
        if (node.level == 2) {
            return node.parent.getDeepSize() < 500;
        }
        return true;
    }

    public TreeNode() {
        this.level = 0;
        this.parent = null;
    }

    TreeNode(TreeNode parent) {
        this.level = parent.level + 1;
        this.parent = parent;
    }

    private synchronized Map<String, TreeNode> getChildMap() {
        if (this.children == null) {
            this.children = new ConcurrentHashMap<String, TreeNode>();
        }
        return this.children;
    }

    public @Nullable TreeNode tryInsert(String s) {
        Map<String, TreeNode> childMap = this.getChildMap();
        if (!TreeNode.allowInsert(this)) {
            return null;
        }
        return childMap.compute(s, (key, prev) -> {
            if (prev != null) {
                return prev;
            }
            this.cachedDeepSize = Integer.MIN_VALUE;
            return new TreeNode(this);
        });
    }

    public Optional<Map<String, TreeNode>> getChildren() {
        return Optional.ofNullable(this.children);
    }

    public int getDeepSize() {
        if (this.cachedDeepSize != Integer.MIN_VALUE) {
            return this.cachedDeepSize;
        }
        if (this.children == null) {
            this.cachedDeepSize = 1;
            return 1;
        }
        this.cachedDeepSize = this.children.values().stream().mapToInt(TreeNode::getDeepSize).sum();
        return this.cachedDeepSize;
    }

    public ImmutableTreeNode makeImmutableCopy() {
        if (this.children == null) {
            return new ImmutableTreeNode(null);
        }
        return new ImmutableTreeNode(this.children.entrySet().stream().map(e -> Maps.immutableEntry(e.getKey(), (Object)((TreeNode)e.getValue()).makeImmutableCopy())));
    }
}

