/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.util;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class MoreFiles {
    private MoreFiles() {
    }

    public static Path createFileIfNotExists(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
        return path;
    }

    public static Path createDirectoryIfNotExists(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && (Files.isDirectory(path, new LinkOption[0]) || Files.isSymbolicLink(path))) {
            return path;
        }
        Files.createDirectory(path, new FileAttribute[0]);
        return path;
    }

    public static Path createDirectoriesIfNotExists(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && (Files.isDirectory(path, new LinkOption[0]) || Files.isSymbolicLink(path))) {
            return path;
        }
        Files.createDirectories(path, new FileAttribute[0]);
        return path;
    }

    public static void deleteDirectory(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> contents = Files.newDirectoryStream(path);){
            for (Path file : contents) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    MoreFiles.deleteDirectory(file);
                    continue;
                }
                Files.delete(file);
            }
        }
        Files.delete(path);
    }
}

