/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.util;

import java.util.HashSet;
import java.util.Set;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.sender.Sender;

public class ProgressLogger {
    public static final int DEFAULT_NOTIFY_FREQUENCY = 500;
    private final Message logMessage;
    private final Message logProgressMessage;
    private final String logPrefixParam;
    private final Set<Sender> listeners = new HashSet<Sender>();

    public ProgressLogger(Message logMessage, Message logProgressMessage, String logPrefixParam) {
        this.logMessage = logMessage;
        this.logProgressMessage = logProgressMessage;
        this.logPrefixParam = logPrefixParam;
    }

    public void addListener(Sender sender) {
        this.listeners.add(sender);
    }

    public Set<Sender> getListeners() {
        return this.listeners;
    }

    public void log(String msg) {
        this.dispatchMessage(this.logMessage, msg);
    }

    public void logError(String msg) {
        this.dispatchMessage(this.logMessage, "Error -> " + msg);
    }

    public void logAllProgress(String msg, int amount) {
        this.dispatchMessage(this.logProgressMessage, msg.replace("{}", Integer.toString(amount)));
    }

    public void logProgress(String msg, int amount, int notifyFrequency) {
        if (amount % notifyFrequency == 0) {
            this.logAllProgress(msg, amount);
        }
    }

    private Object[] formParams(String content) {
        if (this.logPrefixParam != null) {
            return new Object[]{this.logPrefixParam, content};
        }
        return new Object[]{content};
    }

    private void dispatchMessage(Message messageType, String content) {
        Object[] params = this.formParams(content);
        for (Sender s : this.listeners) {
            messageType.send(s, params);
        }
    }
}

