/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.util;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.serializer.legacy.LegacyComponentSerializer;

public final class TextUtils {
    public static final char SECTION_CHAR = '\u00a7';
    public static final char AMPERSAND_CHAR = '&';

    private TextUtils() {
    }

    public static String joinNewline(String ... strings) {
        return TextUtils.joinNewline(Arrays.stream(strings));
    }

    public static String joinNewline(Stream<String> strings) {
        return strings.collect(Collectors.joining("\n"));
    }

    public static TextComponent fromLegacy(String input, char character) {
        return LegacyComponentSerializer.legacy().deserialize(input, character);
    }

    public static TextComponent fromLegacy(String input) {
        return LegacyComponentSerializer.legacy().deserialize(input);
    }

    public static String toLegacy(Component component, char character) {
        return LegacyComponentSerializer.legacy().serialize(component, character);
    }

    public static String toLegacy(Component component) {
        return LegacyComponentSerializer.legacy().serialize(component);
    }

    public static String rewritePlaceholders(String input) {
        int i = 0;
        while (input.contains("{}")) {
            input = input.replaceFirst("\\{\\}", "{" + i++ + "}");
        }
        return input;
    }
}

