/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose;

import me.lucko.luckperms.common.verbose.InvalidFilterException;
import me.lucko.luckperms.common.verbose.event.VerboseEvent;
import me.lucko.luckperms.common.verbose.expression.BooleanExpressionCompiler;

public final class VerboseFilter {
    private final String expression;
    private final BooleanExpressionCompiler.AST ast;

    public VerboseFilter(String expression) throws InvalidFilterException {
        this.expression = expression;
        if (expression.isEmpty()) {
            this.ast = BooleanExpressionCompiler.AST.ALWAYS_TRUE;
        } else {
            try {
                this.ast = BooleanExpressionCompiler.compile(expression);
            }
            catch (BooleanExpressionCompiler.LexerException | BooleanExpressionCompiler.ParserException e) {
                throw new InvalidFilterException("Exception occurred whilst generating an expression for '" + expression + "'", e);
            }
        }
    }

    public boolean evaluate(VerboseEvent data) {
        try {
            return this.ast.eval(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isBlank() {
        return this.ast == BooleanExpressionCompiler.AST.ALWAYS_TRUE;
    }

    public String toString() {
        return this.isBlank() ? "any" : this.expression;
    }
}

