/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import me.lucko.luckperms.common.calculator.result.TristateResult;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.DurationFormatter;
import me.lucko.luckperms.common.util.StackTracePrinter;
import me.lucko.luckperms.common.util.TextUtils;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import me.lucko.luckperms.common.util.gson.JArray;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.verbose.VerboseFilter;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import me.lucko.luckperms.common.verbose.event.PermissionCheckEvent;
import me.lucko.luckperms.common.verbose.event.VerboseEvent;
import me.lucko.luckperms.common.web.AbstractHttpClient;
import me.lucko.luckperms.common.web.BytebinClient;
import me.lucko.luckperms.common.web.UnsuccessfulRequestException;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import net.luckperms.api.query.QueryMode;
import net.luckperms.api.util.Tristate;

public class VerboseListener {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z").withZone(ZoneId.systemDefault());
    private static final int DATA_TRUNCATION = 10000;
    private static final int STACK_TRUNCATION_CHAT = 15;
    private static final int STACK_TRUNCATION_WEB = 40;
    private static final StackTracePrinter FILTERING_PRINTER = StackTracePrinter.builder().ignoreClassStartingWith("me.lucko.luckperms.").ignoreClass("java.util.concurrent.CompletableFuture").ignoreClass("java.util.concurrent.ConcurrentHashMap").build();
    private static final StackTracePrinter CHAT_FILTERED_PRINTER = FILTERING_PRINTER.toBuilder().truncateLength(15).build();
    private static final StackTracePrinter CHAT_UNFILTERED_PRINTER = StackTracePrinter.builder().truncateLength(15).build();
    private static final StackTracePrinter WEB_FILTERED_PRINTER = FILTERING_PRINTER.toBuilder().truncateLength(40).build();
    private static final StackTracePrinter WEB_UNFILTERED_PRINTER = StackTracePrinter.builder().truncateLength(40).build();
    private final Instant startTime = Instant.now();
    private final Sender notifiedSender;
    private final VerboseFilter filter;
    private final boolean notify;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final AtomicInteger matchedCounter = new AtomicInteger(0);
    private final List<VerboseEvent> results = new ArrayList<VerboseEvent>(1000);

    public VerboseListener(Sender notifiedSender, VerboseFilter filter, boolean notify) {
        this.notifiedSender = notifiedSender;
        this.filter = filter;
        this.notify = notify;
    }

    public void acceptEvent(VerboseEvent event) {
        this.counter.incrementAndGet();
        if (!this.filter.evaluate(event)) {
            return;
        }
        this.matchedCounter.incrementAndGet();
        if (this.results.size() < 10000) {
            this.results.add(event);
        }
        if (this.notify) {
            this.sendNotification(event);
        }
    }

    private void sendNotification(VerboseEvent event) {
        TextComponent textComponent;
        if (this.notifiedSender.isConsole()) {
            if (event instanceof PermissionCheckEvent) {
                PermissionCheckEvent permissionEvent = (PermissionCheckEvent)event;
                Message.VERBOSE_LOG_PERMISSION.send(this.notifiedSender, permissionEvent.getCheckTarget(), permissionEvent.getPermission(), VerboseListener.getTristateColor(permissionEvent.getResult().result()), permissionEvent.getResult().result().name().toLowerCase());
            } else if (event instanceof MetaCheckEvent) {
                MetaCheckEvent metaEvent = (MetaCheckEvent)event;
                Message.VERBOSE_LOG_META.send(this.notifiedSender, metaEvent.getCheckTarget(), metaEvent.getKey(), metaEvent.getResult());
            } else {
                throw new IllegalArgumentException("Unknown event type: " + event);
            }
            return;
        }
        if (event instanceof PermissionCheckEvent) {
            PermissionCheckEvent permissionEvent = (PermissionCheckEvent)event;
            textComponent = Message.VERBOSE_LOG_PERMISSION.asComponent(this.notifiedSender.getPlugin().getLocaleManager(), permissionEvent.getCheckTarget(), permissionEvent.getPermission(), VerboseListener.getTristateColor(permissionEvent.getResult().result()), permissionEvent.getResult().result().name().toLowerCase());
        } else if (event instanceof MetaCheckEvent) {
            MetaCheckEvent metaEvent = (MetaCheckEvent)event;
            textComponent = Message.VERBOSE_LOG_META.asComponent(this.notifiedSender.getPlugin().getLocaleManager(), metaEvent.getCheckTarget(), metaEvent.getKey(), metaEvent.getResult());
        } else {
            throw new IllegalArgumentException("Unknown event type: " + event);
        }
        ArrayList<String> hover = new ArrayList<String>();
        if (event instanceof PermissionCheckEvent) {
            PermissionCheckEvent permissionEvent = (PermissionCheckEvent)event;
            hover.add("&aType: &2permission");
            hover.add("&bOrigin: &2" + permissionEvent.getOrigin().name());
            TristateResult result = permissionEvent.getResult();
            if (result.processorClass() != null) {
                hover.add("&bProcessor: &2" + result.processorClass().getName());
            }
            if (result.cause() != null) {
                hover.add("&bCause: &2" + result.cause());
            }
        }
        if (event instanceof MetaCheckEvent) {
            MetaCheckEvent metaEvent = (MetaCheckEvent)event;
            hover.add("&aType: &2meta");
            hover.add("&bOrigin: &2" + metaEvent.getOrigin().name());
        }
        if (event.getCheckQueryOptions().mode() == QueryMode.CONTEXTUAL) {
            hover.add("&bContext: &r" + MessageUtils.contextSetToString(this.notifiedSender.getPlugin().getLocaleManager(), event.getCheckQueryOptions().context()));
        }
        hover.add("&bThread: &r" + event.getCheckThread());
        hover.add("&bTrace: &r");
        Consumer<StackTraceElement> printer = StackTracePrinter.elementToString(str -> hover.add("&7" + str));
        int overflow = VerboseListener.shouldFilterStackTrace(event) ? CHAT_FILTERED_PRINTER.process(event.getCheckTrace(), printer) : CHAT_UNFILTERED_PRINTER.process(event.getCheckTrace(), printer);
        if (overflow != 0) {
            hover.add("&f... and " + overflow + " more");
        }
        HoverEvent hoverEvent = HoverEvent.showText((Component)TextUtils.fromLegacy(TextUtils.joinNewline(hover.stream()), '&'));
        TextComponent text = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)textComponent.toBuilder()).applyDeep(comp -> comp.hoverEvent(hoverEvent))).build();
        this.notifiedSender.sendMessage((Component)text);
    }

    private static boolean shouldFilterStackTrace(VerboseEvent event) {
        if (event instanceof PermissionCheckEvent) {
            PermissionCheckEvent permissionEvent = (PermissionCheckEvent)event;
            return permissionEvent.getOrigin() == PermissionCheckEvent.Origin.PLATFORM_LOOKUP_CHECK || permissionEvent.getOrigin() == PermissionCheckEvent.Origin.PLATFORM_PERMISSION_CHECK;
        }
        return false;
    }

    public String uploadPasteData(BytebinClient bytebin) throws IOException, UnsuccessfulRequestException {
        String startDate = DATE_FORMAT.format(this.startTime);
        String endDate = DATE_FORMAT.format(Instant.now());
        String duration = DurationFormatter.CONCISE.format(Duration.between(this.startTime, Instant.now()));
        boolean truncated = this.matchedCounter.get() > this.results.size();
        JObject metadata = new JObject().add("startTime", startDate).add("endTime", endDate).add("duration", duration).add("count", new JObject().add("matched", this.matchedCounter.get()).add("total", this.counter.get())).add("uploader", new JObject().add("name", this.notifiedSender.getNameWithLocation()).add("uuid", this.notifiedSender.getUniqueId().toString())).add("filter", this.filter.toString()).add("truncated", truncated);
        JArray data = new JArray();
        for (VerboseEvent events : this.results) {
            data.add((JsonElement)events.toJson(VerboseListener.shouldFilterStackTrace(events) ? WEB_FILTERED_PRINTER : WEB_UNFILTERED_PRINTER));
        }
        this.results.clear();
        JsonObject payload = new JObject().add("metadata", metadata).add("data", data).toJson();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(bytesOut), StandardCharsets.UTF_8);){
            GsonProvider.prettyPrinting().toJson((JsonElement)payload, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytebin.postContent(bytesOut.toByteArray(), AbstractHttpClient.JSON_TYPE, false).key();
    }

    private static String getTristateColor(Tristate tristate) {
        switch (tristate) {
            case TRUE: {
                return "&2";
            }
            case FALSE: {
                return "&c";
            }
        }
        return "&7";
    }

    public Sender getNotifiedSender() {
        return this.notifiedSender;
    }
}

