/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose.expression;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class BooleanExpressionCompiler {
    public static AST compile(String expression) throws LexerException, ParserException {
        return new Parser(new Lexer(expression)).parse();
    }

    private static final class VariableToken
    implements Token {
        final String string;

        VariableToken(String string) {
            this.string = string;
        }
    }

    private static enum ConstantToken implements Token
    {
        OPEN_BRACKET,
        CLOSE_BRACKET,
        AND,
        OR,
        NOT,
        EOF;

    }

    private static interface Token {
    }

    private static final class Lexer
    extends AbstractIterator<Token> {
        private final StreamTokenizer tokenizer;
        private boolean end = false;

        Lexer(String expression) {
            this.tokenizer = new StreamTokenizer(new StringReader(expression));
            this.tokenizer.resetSyntax();
            this.tokenizer.wordChars(33, 126);
            this.tokenizer.whitespaceChars(0, 32);
            "()&|!".chars().forEach(this.tokenizer::ordinaryChar);
        }

        protected Token computeNext() {
            if (this.end) {
                return (Token)this.endOfData();
            }
            try {
                int token = this.tokenizer.nextToken();
                switch (token) {
                    case -1: {
                        this.end = true;
                        return ConstantToken.EOF;
                    }
                    case -3: {
                        return new VariableToken(this.tokenizer.sval);
                    }
                    case 40: {
                        return ConstantToken.OPEN_BRACKET;
                    }
                    case 41: {
                        return ConstantToken.CLOSE_BRACKET;
                    }
                    case 38: {
                        return ConstantToken.AND;
                    }
                    case 124: {
                        return ConstantToken.OR;
                    }
                    case 33: {
                        return ConstantToken.NOT;
                    }
                }
                throw new LexerException("Unknown token: " + (char)token + "(" + token + ")");
            }
            catch (IOException e) {
                throw new LexerException(e);
            }
        }
    }

    private static final class Variable
    implements AST {
        String variable;

        private Variable() {
        }

        @Override
        public boolean eval(VariableEvaluator variableEvaluator) {
            return variableEvaluator.eval(this.variable);
        }
    }

    private static final class Not
    implements AST {
        AST child;

        private Not() {
        }

        @Override
        public boolean eval(VariableEvaluator variableEvaluator) {
            return !this.child.eval(variableEvaluator);
        }
    }

    private static final class Or
    implements AST {
        AST left;
        AST right;

        private Or() {
        }

        @Override
        public boolean eval(VariableEvaluator variableEvaluator) {
            return this.left.eval(variableEvaluator) || this.right.eval(variableEvaluator);
        }
    }

    private static final class And
    implements AST {
        AST left;
        AST right;

        private And() {
        }

        @Override
        public boolean eval(VariableEvaluator variableEvaluator) {
            return this.left.eval(variableEvaluator) && this.right.eval(variableEvaluator);
        }
    }

    private static final class Parser {
        private final Lexer lexer;
        private Token currentToken;
        private AST root;

        Parser(Lexer lexer) {
            this.lexer = lexer;
        }

        AST parse() {
            this.exp();
            return this.root;
        }

        private void exp() {
            this.term();
            while (this.currentToken == ConstantToken.OR) {
                Or or = new Or();
                or.left = this.root;
                this.term();
                or.right = this.root;
                this.root = or;
            }
        }

        private void term() {
            this.factor();
            while (this.currentToken == ConstantToken.AND) {
                And and = new And();
                and.left = this.root;
                this.factor();
                and.right = this.root;
                this.root = and;
            }
        }

        private void factor() {
            this.currentToken = (Token)this.lexer.next();
            if (this.currentToken instanceof VariableToken) {
                Variable variable = new Variable();
                variable.variable = ((VariableToken)this.currentToken).string;
                this.root = variable;
                this.currentToken = (Token)this.lexer.next();
            } else if (this.currentToken == ConstantToken.NOT) {
                Not not = new Not();
                this.factor();
                not.child = this.root;
                this.root = not;
            } else if (this.currentToken == ConstantToken.OPEN_BRACKET) {
                this.exp();
                if (this.currentToken != ConstantToken.CLOSE_BRACKET) {
                    throw new ParserException("Brackets are not matched");
                }
                this.currentToken = (Token)this.lexer.next();
            } else {
                throw new ParserException("Malformed expression");
            }
        }
    }

    public static final class ParserException
    extends RuntimeException {
        ParserException(String message) {
            super(message);
        }
    }

    public static final class LexerException
    extends RuntimeException {
        LexerException(String message) {
            super(message);
        }

        LexerException(Throwable cause) {
            super(cause);
        }
    }

    public static interface AST {
        public static final AST ALWAYS_TRUE = e -> true;

        public boolean eval(VariableEvaluator var1);
    }

    @FunctionalInterface
    public static interface VariableEvaluator {
        public boolean eval(String var1);
    }
}

