/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.web;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.context.ContextSetJsonSerializer;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.node.utils.NodeJsonSerializer;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import me.lucko.luckperms.common.util.gson.JArray;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.web.AbstractHttpClient;
import me.lucko.luckperms.common.web.BytebinClient;
import me.lucko.luckperms.common.web.UnsuccessfulRequestException;
import me.lucko.luckperms.lib.text.BuildableComponent;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.ClickEvent;
import me.lucko.luckperms.lib.text.event.HoverEvent;
import me.lucko.luckperms.lib.text.format.TextColor;
import net.luckperms.api.node.Node;

public final class WebEditor {
    private WebEditor() {
    }

    private static JObject writeData(PermissionHolder holder) {
        return new JObject().add("type", holder.getType().toString()).add("id", holder.getObjectName()).add("displayName", holder.getPlainDisplayName()).add("nodes", (JsonElement)NodeJsonSerializer.serializeNodes((Collection<Node>)holder.normalData().immutable().values()));
    }

    private static JObject writeData(Track track) {
        return new JObject().add("type", "track").add("id", track.getName()).add("groups", new JArray().consume(a -> track.getGroups().forEach(a::add)));
    }

    public static JsonObject formPayload(List<PermissionHolder> holders, List<Track> tracks, Sender sender, String cmdLabel, LuckPermsPlugin plugin) {
        Preconditions.checkArgument((!holders.isEmpty() ? 1 : 0) != 0, (Object)"holders is empty");
        return new JObject().add("metadata", new JObject().add("commandAlias", cmdLabel).add("uploader", new JObject().add("name", sender.getNameWithLocation()).add("uuid", sender.getUniqueId().toString())).add("time", System.currentTimeMillis()).add("pluginVersion", plugin.getBootstrap().getVersion())).add("permissionHolders", new JArray().consume(arr -> {
            for (PermissionHolder holder : holders) {
                arr.add(WebEditor.writeData(holder));
            }
        })).add("tracks", new JArray().consume(arr -> {
            for (Track track : tracks) {
                arr.add(WebEditor.writeData(track));
            }
        })).add("knownPermissions", new JArray().consume(arr -> {
            for (String perm : plugin.getPermissionRegistry().rootAsList()) {
                arr.add(perm);
            }
        })).consume(o -> o.add("potentialContexts", (JsonElement)ContextSetJsonSerializer.serializeContextSet(plugin.getContextManager().getPotentialContexts()))).toJson();
    }

    public static CommandResult post(JsonObject payload, Sender sender, LuckPermsPlugin plugin) {
        String pasteId;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(bytesOut), StandardCharsets.UTF_8);){
            GsonProvider.prettyPrinting().toJson((JsonElement)payload, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            pasteId = plugin.getBytebin().postContent(bytesOut.toByteArray(), AbstractHttpClient.JSON_TYPE, false).key();
        }
        catch (UnsuccessfulRequestException e) {
            Message.EDITOR_HTTP_REQUEST_FAILURE.send(sender, e.getResponse().code(), e.getResponse().message());
            return CommandResult.STATE_ERROR;
        }
        catch (IOException e) {
            new RuntimeException("Error uploading data to bytebin", e).printStackTrace();
            Message.EDITOR_HTTP_UNKNOWN_FAILURE.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        String url = plugin.getConfiguration().get(ConfigKeys.WEB_EDITOR_URL_PATTERN) + pasteId;
        Message.EDITOR_URL.send(sender, new Object[0]);
        BuildableComponent message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder((String)url).color(TextColor.AQUA)).clickEvent(ClickEvent.openUrl((String)url))).hoverEvent(HoverEvent.showText((Component)TextComponent.of((String)"Click to open the editor.").color(TextColor.GRAY)))).build();
        sender.sendMessage((Component)message);
        return CommandResult.SUCCESS;
    }

    /*
     * Exception decompiling
     */
    public static JsonObject readDataFromBytebin(BytebinClient bytebin, String id) throws IOException, UnsuccessfulRequestException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

