/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import me.lucko.luckperms.common.dependencies.classloader.PluginClassLoader;
import me.lucko.luckperms.common.dependencies.classloader.ReflectionClassLoader;
import me.lucko.luckperms.common.plugin.bootstrap.LuckPermsBootstrap;
import me.lucko.luckperms.common.plugin.logging.PluginLogger;
import me.lucko.luckperms.common.plugin.logging.Slf4jPluginLogger;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.common.util.MoreFiles;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.SpongeSchedulerAdapter;
import net.luckperms.api.platform.Platform;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.scheduler.AsynchronousExecutor;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.SpongeExecutorService;
import org.spongepowered.api.scheduler.SynchronousExecutor;

@Plugin(id="luckperms", name="LuckPerms", version="5.1.17", authors={"Luck"}, description="A permissions plugin", url="https://luckperms.net", dependencies={@Dependency(id="spongeapi")})
public class LPSpongeBootstrap
implements LuckPermsBootstrap {
    private final PluginLogger logger;
    private final SchedulerAdapter schedulerAdapter;
    private final PluginClassLoader classLoader;
    private final LPSpongePlugin plugin;
    private Instant startTime;
    private final CountDownLatch loadLatch = new CountDownLatch(1);
    private final CountDownLatch enableLatch = new CountDownLatch(1);
    @Inject
    private Game game;
    private final Scheduler spongeScheduler;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configDirectory;
    @Inject
    private PluginContainer pluginContainer;

    @Inject
    public LPSpongeBootstrap(Logger logger, @SynchronousExecutor SpongeExecutorService syncExecutor, @AsynchronousExecutor SpongeExecutorService asyncExecutor) {
        this.logger = new Slf4jPluginLogger(logger);
        this.spongeScheduler = Sponge.getScheduler();
        this.schedulerAdapter = new SpongeSchedulerAdapter(this, this.spongeScheduler, syncExecutor, asyncExecutor);
        this.classLoader = new ReflectionClassLoader(this);
        this.plugin = new LPSpongePlugin(this);
    }

    @Override
    public PluginLogger getPluginLogger() {
        return this.logger;
    }

    @Override
    public SchedulerAdapter getScheduler() {
        return this.schedulerAdapter;
    }

    @Override
    public PluginClassLoader getPluginClassLoader() {
        return this.classLoader;
    }

    @Listener(order=Order.FIRST)
    public void onEnable(GamePreInitializationEvent event) {
        this.startTime = Instant.now();
        try {
            this.plugin.load();
        }
        finally {
            this.loadLatch.countDown();
        }
        try {
            this.plugin.enable();
        }
        finally {
            this.enableLatch.countDown();
        }
    }

    @Listener(order=Order.LATE)
    public void onLateEnable(GamePreInitializationEvent event) {
        this.plugin.lateEnable();
    }

    @Listener
    public void onDisable(GameStoppingServerEvent event) {
        this.plugin.disable();
    }

    @Override
    public CountDownLatch getEnableLatch() {
        return this.enableLatch;
    }

    @Override
    public CountDownLatch getLoadLatch() {
        return this.loadLatch;
    }

    public Game getGame() {
        return this.game;
    }

    public Optional<Server> getServer() {
        return this.game.isServerAvailable() ? Optional.of(this.game.getServer()) : Optional.empty();
    }

    public Scheduler getSpongeScheduler() {
        return this.spongeScheduler;
    }

    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    @Override
    public String getVersion() {
        return "5.1.17";
    }

    @Override
    public Instant getStartupTime() {
        return this.startTime;
    }

    @Override
    public Platform.Type getType() {
        return Platform.Type.SPONGE;
    }

    @Override
    public String getServerBrand() {
        return this.game.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getName();
    }

    @Override
    public String getServerVersion() {
        PluginContainer api = this.game.getPlatform().getContainer(Platform.Component.API);
        PluginContainer impl = this.game.getPlatform().getContainer(Platform.Component.IMPLEMENTATION);
        return api.getName() + ": " + api.getVersion().orElse("null") + " - " + impl.getName() + ": " + impl.getVersion().orElse("null");
    }

    @Override
    public Path getDataDirectory() {
        Path dataDirectory = this.game.getGameDirectory().toAbsolutePath().resolve("luckperms");
        try {
            MoreFiles.createDirectoriesIfNotExists(dataDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dataDirectory;
    }

    @Override
    public Path getConfigDirectory() {
        return this.configDirectory.toAbsolutePath();
    }

    @Override
    public InputStream getResourceStream(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    public Optional<Player> getPlayer(UUID uniqueId) {
        return this.getServer().flatMap(s -> s.getPlayer(uniqueId));
    }

    @Override
    public Optional<UUID> lookupUniqueId(String username) {
        return this.getServer().flatMap(server -> (Optional)((CompletableFuture)((CompletableFuture)server.getGameProfileManager().get(username).thenApply(p -> Optional.of(p.getUniqueId()))).exceptionally(x -> Optional.empty())).join());
    }

    @Override
    public Optional<String> lookupUsername(UUID uniqueId) {
        return this.getServer().flatMap(server -> (Optional)((CompletableFuture)((CompletableFuture)server.getGameProfileManager().get(uniqueId).thenApply(GameProfile::getName)).exceptionally(x -> Optional.empty())).join());
    }

    @Override
    public int getPlayerCount() {
        return this.getServer().map(server -> server.getOnlinePlayers().size()).orElse(0);
    }

    @Override
    public Collection<String> getPlayerList() {
        return this.getServer().map(server -> {
            Collection players = server.getOnlinePlayers();
            ArrayList<String> list = new ArrayList<String>(players.size());
            for (Player player : players) {
                list.add(player.getName());
            }
            return list;
        }).orElse(Collections.emptyList());
    }

    @Override
    public Collection<UUID> getOnlinePlayers() {
        return this.getServer().map(server -> {
            Collection players = server.getOnlinePlayers();
            ArrayList<UUID> list = new ArrayList<UUID>(players.size());
            for (Player player : players) {
                list.add(player.getUniqueId());
            }
            return list;
        }).orElse(Collections.emptyList());
    }

    @Override
    public boolean isPlayerOnline(UUID uniqueId) {
        return this.getServer().flatMap(server -> server.getPlayer(uniqueId).map(User::isOnline)).orElse(false);
    }
}

