/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge;

import java.util.UUID;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.sender.SenderFactory;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.adapter.spongeapi.TextAdapter;
import me.lucko.luckperms.sponge.service.CompatibilityUtil;
import net.luckperms.api.util.Tristate;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.serializer.TextSerializers;

public class SpongeSenderFactory
extends SenderFactory<CommandSource> {
    public SpongeSenderFactory(LuckPermsPlugin plugin) {
        super(plugin);
    }

    @Override
    protected String getName(CommandSource source) {
        if (source instanceof Player) {
            return source.getName();
        }
        return "Console";
    }

    @Override
    protected UUID getUniqueId(CommandSource source) {
        if (source instanceof Player) {
            return ((Player)source).getUniqueId();
        }
        return Sender.CONSOLE_UUID;
    }

    @Override
    protected void sendMessage(CommandSource source, String s) {
        source.sendMessage(TextSerializers.LEGACY_FORMATTING_CODE.deserialize(s));
    }

    @Override
    protected void sendMessage(CommandSource source, Component message) {
        TextAdapter.sendComponent((MessageReceiver)source, (Component)message);
    }

    @Override
    protected Tristate getPermissionValue(CommandSource source, String node) {
        Tristate result = CompatibilityUtil.convertTristate(source.getPermissionValue(source.getActiveContexts(), node));
        if (result == Tristate.UNDEFINED && source.hasPermission(node)) {
            result = Tristate.TRUE;
        }
        return result;
    }

    @Override
    protected boolean hasPermission(CommandSource source, String node) {
        return source.hasPermission(node);
    }
}

