/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.calculator;

import me.lucko.luckperms.common.calculator.processor.PermissionProcessor;
import me.lucko.luckperms.common.calculator.result.TristateResult;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;

public abstract class DefaultsProcessor
implements PermissionProcessor {
    private static final TristateResult.Factory TYPE_DEFAULTS_RESULT_FACTORY = new TristateResult.Factory(DefaultsProcessor.class, "type defaults");
    private static final TristateResult.Factory ROOT_DEFAULTS_RESULT_FACTORY = new TristateResult.Factory(DefaultsProcessor.class, "root defaults");
    protected final LPPermissionService service;
    private final QueryOptions queryOptions;

    public DefaultsProcessor(LPPermissionService service, QueryOptions queryOptions) {
        this.service = service;
        this.queryOptions = queryOptions;
    }

    protected abstract LPSubject getTypeDefaults();

    @Override
    public TristateResult hasPermission(String permission) {
        Tristate t = this.getTypeDefaults().getPermissionValue(this.queryOptions, permission);
        if (t != Tristate.UNDEFINED) {
            return TYPE_DEFAULTS_RESULT_FACTORY.result(t);
        }
        t = this.service.getRootDefaults().getPermissionValue(this.queryOptions, permission);
        if (t != Tristate.UNDEFINED) {
            return ROOT_DEFAULTS_RESULT_FACTORY.result(t);
        }
        return TristateResult.UNDEFINED;
    }
}

