/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import java.util.List;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.sponge.commands.SpongeCommandUtils;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import net.luckperms.api.context.ImmutableContextSet;

public class OptionClear
extends ChildCommand<LPSubjectData> {
    public OptionClear(LocaleManager locale) {
        super(CommandSpec.SPONGE_OPTION_CLEAR.localize(locale), "clear", CommandPermission.SPONGE_OPTION_CLEAR, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, LPSubjectData subjectData, List<String> args, String label) {
        ImmutableContextSet contextSet = ArgumentParser.parseContextSponge(0, args);
        if (contextSet.isEmpty()) {
            subjectData.clearOptions();
            Message.BLANK.send(sender, "&aCleared options matching contexts &bANY&a.");
        } else {
            subjectData.clearOptions(contextSet);
            Message.BLANK.send(sender, "&aCleared options matching contexts &b" + SpongeCommandUtils.contextToString(contextSet, plugin.getLocaleManager()));
        }
        return CommandResult.SUCCESS;
    }
}

