/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import java.util.List;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.sponge.commands.SpongeCommandUtils;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import net.luckperms.api.context.ImmutableContextSet;
import org.spongepowered.api.Sponge;

public class ParentAdd
extends ChildCommand<LPSubjectData> {
    public ParentAdd(LocaleManager locale) {
        super(CommandSpec.SPONGE_PARENT_ADD.localize(locale), "add", CommandPermission.SPONGE_PARENT_ADD, Predicates.inRange(0, 1));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, LPSubjectData subjectData, List<String> args, String label) {
        LPSubject subject;
        LPSubjectCollection c;
        String collection = args.get(0);
        String name = args.get(1);
        ImmutableContextSet contextSet = ArgumentParser.parseContextSponge(2, args);
        LPPermissionService service = (LPPermissionService)Sponge.getServiceManager().provideUnchecked(LPPermissionService.class);
        if (service.getLoadedCollections().keySet().stream().map(String::toLowerCase).noneMatch(s -> s.equalsIgnoreCase(collection))) {
            Message.BLANK.send(sender, "Warning: SubjectCollection '&4" + collection + "&c' doesn't already exist.");
        }
        if (!(c = service.getCollection(collection)).hasRegistered(name).join().booleanValue()) {
            Message.BLANK.send(sender, "Warning: Subject '&4" + name + "&c' doesn't already exist.");
        }
        if (subjectData.addParent(contextSet, (subject = c.loadSubject(name).join()).toReference()).join().booleanValue()) {
            Message.BLANK.send(sender, "&aAdded parent &b" + subject.getParentCollection().getIdentifier() + "&a/&b" + subject.getIdentifier() + "&a in context " + SpongeCommandUtils.contextToString(contextSet, plugin.getLocaleManager()));
        } else {
            Message.BLANK.send(sender, "Unable to add parent. Does the Subject already have it added?");
        }
        return CommandResult.SUCCESS;
    }
}

