/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.sponge.commands.SpongeCommandUtils;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;

public class ParentInfo
extends ChildCommand<LPSubjectData> {
    public ParentInfo(LocaleManager locale) {
        super(CommandSpec.SPONGE_PARENT_INFO.localize(locale), "info", CommandPermission.SPONGE_PARENT_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, LPSubjectData subjectData, List<String> args, String label) {
        ImmutableContextSet contextSet = ArgumentParser.parseContextSponge(0, args);
        if (contextSet.isEmpty()) {
            Message.BLANK.send(sender, "&aShowing parents matching contexts &bANY&a.");
            ImmutableMap<ImmutableContextSet, ImmutableList<LPSubjectReference>> parents = subjectData.getAllParents();
            if (parents.isEmpty()) {
                Message.BLANK.send(sender, "That subject does not have any parents defined.");
                return CommandResult.SUCCESS;
            }
            for (Map.Entry e : parents.entrySet()) {
                Message.BLANK.send(sender, "&3>> &bContext: " + SpongeCommandUtils.contextToString((ContextSet)e.getKey(), plugin.getLocaleManager()) + "\n" + SpongeCommandUtils.parentsToString((Iterable)e.getValue()));
            }
        } else {
            ImmutableList<LPSubjectReference> parents = subjectData.getParents(contextSet);
            if (parents.isEmpty()) {
                Message.BLANK.send(sender, "That subject does not have any parents defined in those contexts.");
                return CommandResult.SUCCESS;
            }
            Message.BLANK.send(sender, "&aShowing parents matching contexts &b" + SpongeCommandUtils.contextToString(contextSet, plugin.getLocaleManager()) + "&a.\n" + SpongeCommandUtils.parentsToString(parents));
        }
        return CommandResult.SUCCESS;
    }
}

