/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.sponge.commands.SpongeCommandUtils;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;

public class PermissionInfo
extends ChildCommand<LPSubjectData> {
    public PermissionInfo(LocaleManager locale) {
        super(CommandSpec.SPONGE_PERMISSION_INFO.localize(locale), "info", CommandPermission.SPONGE_PERMISSION_INFO, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, LPSubjectData subjectData, List<String> args, String label) {
        ImmutableContextSet contextSet = ArgumentParser.parseContextSponge(0, args);
        if (contextSet.isEmpty()) {
            Message.BLANK.send(sender, "&aShowing permissions matching contexts &bANY&a.");
            ImmutableMap<ImmutableContextSet, ImmutableMap<String, Boolean>> permissions = subjectData.getAllPermissions();
            if (permissions.isEmpty()) {
                Message.BLANK.send(sender, "That subject does not have any permissions defined.");
                return CommandResult.SUCCESS;
            }
            for (Map.Entry e : permissions.entrySet()) {
                Message.BLANK.send(sender, "&3>> &bContext: " + SpongeCommandUtils.contextToString((ContextSet)e.getKey(), plugin.getLocaleManager()) + "\n" + SpongeCommandUtils.nodesToString((Map)e.getValue()));
            }
        } else {
            ImmutableMap<String, Boolean> permissions = subjectData.getPermissions(contextSet);
            if (permissions.isEmpty()) {
                Message.BLANK.send(sender, "That subject does not have any permissions defined in those contexts.");
                return CommandResult.SUCCESS;
            }
            Message.BLANK.send(sender, "&aShowing permissions matching contexts &b" + SpongeCommandUtils.contextToString(contextSet, plugin.getLocaleManager()) + "&a.\n" + SpongeCommandUtils.nodesToString(permissions));
        }
        return CommandResult.SUCCESS;
    }
}

