/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.context;

import java.util.Collection;
import java.util.HashSet;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Game;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.World;

public class WorldCalculator
implements ContextCalculator<Subject> {
    private final LPSpongePlugin plugin;

    public WorldCalculator(LPSpongePlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void calculate(@NonNull Subject subject, @NonNull ContextConsumer consumer) {
        CommandSource source = subject.getCommandSource().orElse(null);
        if (source == null || !(source instanceof Player)) {
            return;
        }
        Player p = (Player)source;
        HashSet<String> seen = new HashSet<String>();
        String world = p.getWorld().getName().toLowerCase();
        while (seen.add(world)) {
            consumer.accept("world", world);
            world = this.plugin.getConfiguration().get(ConfigKeys.WORLD_REWRITES).getOrDefault(world, world).toLowerCase();
        }
    }

    @Override
    public ContextSet estimatePotentialContexts() {
        Game game = this.plugin.getBootstrap().getGame();
        if (!game.isServerAvailable()) {
            return ImmutableContextSetImpl.EMPTY;
        }
        Collection worlds = game.getServer().getWorlds();
        ImmutableContextSetImpl.BuilderImpl builder = new ImmutableContextSetImpl.BuilderImpl();
        for (World world : worlds) {
            builder.add("world", world.getName().toLowerCase());
        }
        return builder.build();
    }
}

