/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.model.manager;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import me.lucko.luckperms.common.context.contextset.ImmutableContextSetImpl;
import me.lucko.luckperms.common.model.manager.group.AbstractGroupManager;
import me.lucko.luckperms.common.node.matcher.StandardNodeMatchers;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import me.lucko.luckperms.sponge.model.SpongeGroup;
import me.lucko.luckperms.sponge.service.LuckPermsService;
import me.lucko.luckperms.sponge.service.ProxyFactory;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.event.cause.CreationCause;
import net.luckperms.api.util.Tristate;
import org.spongepowered.api.service.permission.SubjectCollection;

public class SpongeGroupManager
extends AbstractGroupManager<SpongeGroup>
implements LPSubjectCollection {
    private final LPSpongePlugin plugin;
    private final LoadingCache<String, LPSubject> subjectLoadingCache;
    private SubjectCollection spongeProxy = null;

    public SpongeGroupManager(LPSpongePlugin plugin) {
        this.plugin = plugin;
        this.subjectLoadingCache = Caffeine.newBuilder().executor(plugin.getBootstrap().getScheduler().async()).expireAfterWrite(1L, TimeUnit.MINUTES).build(s -> {
            SpongeGroup group = (SpongeGroup)this.getIfLoaded(s);
            if (group != null) {
                group.getIoLock().lock();
                group.getIoLock().unlock();
                return group.sponge();
            }
            this.getPlugin().getStorage().createAndLoadGroup((String)s, CreationCause.INTERNAL).join();
            group = (SpongeGroup)this.getIfLoaded(s);
            if (group == null) {
                this.getPlugin().getLogger().severe("Error whilst loading group '" + s + "'.");
                throw new RuntimeException();
            }
            return group.sponge();
        });
    }

    @Override
    public SpongeGroup apply(String name) {
        return new SpongeGroup(name, this.plugin);
    }

    @Override
    public synchronized SubjectCollection sponge() {
        if (this.spongeProxy == null) {
            Objects.requireNonNull(this.plugin.getService(), "service");
            this.spongeProxy = ProxyFactory.toSponge(this);
        }
        return this.spongeProxy;
    }

    public LPSpongePlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public LuckPermsService getService() {
        return this.plugin.getService();
    }

    @Override
    public String getIdentifier() {
        return "group";
    }

    @Override
    public Predicate<String> getIdentifierValidityPredicate() {
        return DataConstraints.GROUP_NAME_TEST;
    }

    @Override
    public CompletableFuture<LPSubject> loadSubject(String identifier) {
        if (!DataConstraints.GROUP_NAME_TEST.test(identifier)) {
            throw new IllegalArgumentException("Illegal subject identifier");
        }
        LPSubject present = (LPSubject)this.subjectLoadingCache.getIfPresent((Object)identifier.toLowerCase());
        if (present != null) {
            return CompletableFuture.completedFuture(present);
        }
        return CompletableFuture.supplyAsync(() -> (LPSubject)this.subjectLoadingCache.get((Object)identifier.toLowerCase()), this.plugin.getBootstrap().getScheduler().async());
    }

    @Override
    public Optional<LPSubject> getSubject(String identifier) {
        if (!DataConstraints.GROUP_NAME_TEST.test(identifier)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getIfLoaded(identifier.toLowerCase())).map(SpongeGroup::sponge);
    }

    @Override
    public CompletableFuture<Boolean> hasRegistered(String identifier) {
        if (!DataConstraints.GROUP_NAME_TEST.test(identifier)) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.completedFuture(this.isLoaded(identifier.toLowerCase()));
    }

    @Override
    public CompletableFuture<ImmutableCollection<LPSubject>> loadSubjects(Set<String> identifiers) {
        return CompletableFuture.supplyAsync(() -> {
            ImmutableSet.Builder subjects = ImmutableSet.builder();
            for (String id : identifiers) {
                if (!DataConstraints.GROUP_NAME_TEST.test(id)) continue;
                subjects.add((Object)this.loadSubject(id.toLowerCase()).join());
            }
            return subjects.build();
        }, this.plugin.getBootstrap().getScheduler().async());
    }

    @Override
    public ImmutableCollection<LPSubject> getLoadedSubjects() {
        return (ImmutableCollection)this.getAll().values().stream().map(SpongeGroup::sponge).collect(ImmutableCollectors.toSet());
    }

    @Override
    public CompletableFuture<ImmutableSet<String>> getAllIdentifiers() {
        return CompletableFuture.completedFuture(ImmutableSet.copyOf(this.getAll().keySet()));
    }

    @Override
    public CompletableFuture<ImmutableMap<LPSubjectReference, Boolean>> getAllWithPermission(String permission) {
        return CompletableFuture.supplyAsync(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            List<NodeEntry<String, String>> lookup = this.plugin.getStorage().getGroupsWithPermission(StandardNodeMatchers.key(permission)).join();
            for (NodeEntry<String, String> holder : lookup) {
                if (!holder.getNode().getContexts().equals(ImmutableContextSetImpl.EMPTY)) continue;
                builder.put((Object)this.getService().getReferenceFactory().obtain(this.getIdentifier(), (String)holder.getHolder()), (Object)holder.getNode().getValue());
            }
            return builder.build();
        }, this.plugin.getBootstrap().getScheduler().async());
    }

    @Override
    public CompletableFuture<ImmutableMap<LPSubjectReference, Boolean>> getAllWithPermission(ImmutableContextSet contexts, String permission) {
        return CompletableFuture.supplyAsync(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            List<NodeEntry<String, String>> lookup = this.plugin.getStorage().getGroupsWithPermission(StandardNodeMatchers.key(permission)).join();
            for (NodeEntry<String, String> holder : lookup) {
                if (!holder.getNode().getContexts().equals(contexts)) continue;
                builder.put((Object)this.getService().getReferenceFactory().obtain(this.getIdentifier(), (String)holder.getHolder()), (Object)holder.getNode().getValue());
            }
            return builder.build();
        }, this.plugin.getBootstrap().getScheduler().async());
    }

    @Override
    public ImmutableMap<LPSubject, Boolean> getLoadedWithPermission(String permission) {
        return this.getAll().values().stream().map(SpongeGroup::sponge).map(sub -> Maps.immutableEntry((Object)sub, (Object)((Object)sub.getPermissionValue(ImmutableContextSetImpl.EMPTY, permission)))).filter(pair -> pair.getValue() != Tristate.UNDEFINED).collect(ImmutableCollectors.toMap(Map.Entry::getKey, sub -> ((Tristate)((Object)((Object)sub.getValue()))).asBoolean()));
    }

    @Override
    public ImmutableMap<LPSubject, Boolean> getLoadedWithPermission(ImmutableContextSet contexts, String permission) {
        return this.getAll().values().stream().map(SpongeGroup::sponge).map(sub -> Maps.immutableEntry((Object)sub, (Object)((Object)sub.getPermissionValue(contexts, permission)))).filter(pair -> pair.getValue() != Tristate.UNDEFINED).collect(ImmutableCollectors.toMap(Map.Entry::getKey, sub -> ((Tristate)((Object)((Object)sub.getValue()))).asBoolean()));
    }

    @Override
    public LPSubject getDefaults() {
        return this.getService().getDefaultSubjects().getTypeDefaults(this.getIdentifier());
    }
}

