/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import me.lucko.luckperms.common.context.ForwardingContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.context.Contextual;
import org.spongepowered.api.service.permission.Subject;

public class ContextCalculatorProxy
implements ForwardingContextCalculator<Subject> {
    private final ContextCalculator<Subject> delegate;

    public ContextCalculatorProxy(ContextCalculator<Subject> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void calculate(@NonNull Subject subject, @NonNull ContextConsumer consumer) {
        this.delegate.accumulateContexts((Contextual)subject, (Set)new ForwardingContextSet(consumer));
    }

    @Override
    public Object delegate() {
        return this.delegate;
    }

    private static final class ForwardingContextSet
    implements Set<Context> {
        private final ContextConsumer consumer;

        private ForwardingContextSet(ContextConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public boolean add(Context context) {
            if (context.getKey().isEmpty() || context.getValue().isEmpty()) {
                return false;
            }
            this.consumer.accept(context.getKey(), context.getValue());
            return true;
        }

        @Override
        public boolean addAll(@NonNull Collection<? extends Context> c) {
            for (Context context : c) {
                this.add(context);
            }
            return true;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @NonNull Iterator<Context> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @NonNull Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> @NonNull T[] toArray(@NonNull T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(@NonNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@NonNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@NonNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

