/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.model.calculated;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.common.cacheddata.AbstractCachedDataManager;
import me.lucko.luckperms.common.cacheddata.CacheMetadata;
import me.lucko.luckperms.common.cacheddata.type.MetaAccumulator;
import me.lucko.luckperms.common.calculator.CalculatorFactory;
import me.lucko.luckperms.common.calculator.PermissionCalculator;
import me.lucko.luckperms.common.calculator.processor.MapProcessor;
import me.lucko.luckperms.common.calculator.processor.PermissionProcessor;
import me.lucko.luckperms.common.calculator.processor.SpongeWildcardProcessor;
import me.lucko.luckperms.common.calculator.processor.WildcardProcessor;
import me.lucko.luckperms.common.metastacking.SimpleMetaStackDefinition;
import me.lucko.luckperms.common.metastacking.StandardStackElements;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.sponge.calculator.FixedDefaultsProcessor;
import me.lucko.luckperms.sponge.service.model.calculated.CalculatedSubject;
import net.luckperms.api.metastacking.DuplicateRemovalFunction;
import net.luckperms.api.metastacking.MetaStackDefinition;
import net.luckperms.api.metastacking.MetaStackElement;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.query.QueryOptions;

public class CalculatedSubjectCachedDataManager
extends AbstractCachedDataManager
implements CalculatorFactory {
    private static final MetaStackDefinition DEFAULT_META_STACK = new SimpleMetaStackDefinition((List<MetaStackElement>)ImmutableList.of((Object)StandardStackElements.HIGHEST), DuplicateRemovalFunction.RETAIN_ALL, "", "", "");
    private final CalculatedSubject subject;

    CalculatedSubjectCachedDataManager(CalculatedSubject subject, LuckPermsPlugin plugin) {
        super(plugin);
        this.subject = subject;
    }

    @Override
    protected CacheMetadata getMetadataForQueryOptions(QueryOptions queryOptions) {
        return new CacheMetadata(null, this.subject.getParentCollection().getIdentifier() + "/" + this.subject.getIdentifier(), queryOptions);
    }

    @Override
    protected QueryOptions getQueryOptions() {
        return this.subject.sponge().getQueryOptions();
    }

    @Override
    protected CalculatorFactory getCalculatorFactory() {
        return this;
    }

    @Override
    protected MetaStackDefinition getDefaultMetaStackDefinition(ChatMetaType type) {
        return DEFAULT_META_STACK;
    }

    @Override
    protected Map<String, Boolean> resolvePermissions(QueryOptions queryOptions) {
        return this.subject.resolveAllPermissions(queryOptions);
    }

    @Override
    protected void resolveMeta(MetaAccumulator accumulator, QueryOptions queryOptions) {
        this.subject.resolveAllOptions(accumulator, queryOptions);
    }

    @Override
    public PermissionCalculator build(QueryOptions queryOptions, CacheMetadata metadata) {
        ImmutableList.Builder processors = ImmutableList.builder();
        processors.add((Object)new MapProcessor());
        processors.add((Object)new SpongeWildcardProcessor());
        processors.add((Object)new WildcardProcessor());
        if (!this.subject.getParentCollection().isDefaultsCollection()) {
            processors.add((Object)new FixedDefaultsProcessor(this.subject.getService(), queryOptions, this.subject.getDefaults()));
        }
        return new PermissionCalculator(this.getPlugin(), metadata, (ImmutableList<PermissionProcessor>)processors.build());
    }
}

