/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.model.calculated;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.luckperms.common.context.ContextSetComparator;
import me.lucko.luckperms.sponge.service.ProxyFactory;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;
import org.spongepowered.api.service.permission.SubjectData;

public class CalculatedSubjectData
implements LPSubjectData {
    private final LPSubject parentSubject;
    private final DataType type;
    private final LPPermissionService service;
    private final Map<ImmutableContextSet, Map<String, Boolean>> permissions = new ConcurrentHashMap<ImmutableContextSet, Map<String, Boolean>>();
    private final Map<ImmutableContextSet, Set<LPSubjectReference>> parents = new ConcurrentHashMap<ImmutableContextSet, Set<LPSubjectReference>>();
    private final Map<ImmutableContextSet, Map<String, String>> options = new ConcurrentHashMap<ImmutableContextSet, Map<String, String>>();

    public CalculatedSubjectData(LPSubject parentSubject, DataType type, LPPermissionService service) {
        this.parentSubject = parentSubject;
        this.type = type;
        this.service = service;
    }

    @Override
    public SubjectData sponge() {
        return ProxyFactory.toSponge(this);
    }

    @Override
    public LPSubject getParentSubject() {
        return this.parentSubject;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    public void replacePermissions(Map<ImmutableContextSet, Map<String, Boolean>> map) {
        this.permissions.clear();
        for (Map.Entry<ImmutableContextSet, Map<String, Boolean>> e : map.entrySet()) {
            this.permissions.put(e.getKey(), new ConcurrentHashMap<String, Boolean>(e.getValue()));
        }
        this.service.invalidateAllCaches();
    }

    public void replaceParents(Map<ImmutableContextSet, List<LPSubjectReference>> map) {
        this.parents.clear();
        for (Map.Entry<ImmutableContextSet, List<LPSubjectReference>> e : map.entrySet()) {
            ConcurrentHashMap.KeySetView set = ConcurrentHashMap.newKeySet();
            set.addAll(e.getValue());
            this.parents.put(e.getKey(), set);
        }
        this.service.invalidateAllCaches();
    }

    public void replaceOptions(Map<ImmutableContextSet, Map<String, String>> map) {
        this.options.clear();
        for (Map.Entry<ImmutableContextSet, Map<String, String>> e : map.entrySet()) {
            this.options.put(e.getKey(), new ConcurrentHashMap<String, String>(e.getValue()));
        }
        this.service.invalidateAllCaches();
    }

    @Override
    public ImmutableMap<ImmutableContextSet, ImmutableMap<String, Boolean>> getAllPermissions() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<ImmutableContextSet, Map<String, Boolean>> e : this.permissions.entrySet()) {
            map.put((Object)e.getKey(), (Object)ImmutableMap.copyOf(e.getValue()));
        }
        return map.build();
    }

    @Override
    public ImmutableMap<String, Boolean> getPermissions(ImmutableContextSet contexts) {
        return ImmutableMap.copyOf(this.permissions.getOrDefault(contexts, (Map<String, Boolean>)ImmutableMap.of()));
    }

    public Map<String, Boolean> resolvePermissions(QueryOptions filter) {
        TreeMap<ImmutableContextSet, Map<String, Boolean>> sorted = new TreeMap<ImmutableContextSet, Map<String, Boolean>>(ContextSetComparator.reverse());
        for (Map.Entry<ImmutableContextSet, Map<String, Boolean>> entry : this.permissions.entrySet()) {
            if (!filter.satisfies(entry.getKey())) continue;
            sorted.put(entry.getKey(), entry.getValue());
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Map map : sorted.values()) {
            for (Map.Entry e : map.entrySet()) {
                result.putIfAbsent((String)e.getKey(), (Boolean)e.getValue());
            }
        }
        return result;
    }

    @Override
    public CompletableFuture<Boolean> setPermission(ImmutableContextSet contexts, String permission, Tristate value) {
        boolean b;
        if (value == Tristate.UNDEFINED) {
            Map<String, Boolean> perms = this.permissions.get(contexts);
            b = perms != null && perms.remove(permission.toLowerCase()) != null;
        } else {
            Map perms = this.permissions.computeIfAbsent(contexts, c -> new ConcurrentHashMap());
            boolean bl = b = !Objects.equals(perms.put(permission.toLowerCase(), value.asBoolean()), value.asBoolean());
        }
        if (b) {
            this.service.invalidateAllCaches();
        }
        return CompletableFuture.completedFuture(b);
    }

    @Override
    public CompletableFuture<Boolean> clearPermissions() {
        if (this.permissions.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        this.permissions.clear();
        this.service.invalidateAllCaches();
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> clearPermissions(ImmutableContextSet contexts) {
        Map<String, Boolean> perms = this.permissions.get(contexts);
        if (perms == null) {
            return CompletableFuture.completedFuture(false);
        }
        this.permissions.remove(contexts);
        if (!perms.isEmpty()) {
            this.service.invalidateAllCaches();
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public ImmutableMap<ImmutableContextSet, ImmutableList<LPSubjectReference>> getAllParents() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<ImmutableContextSet, Set<LPSubjectReference>> e : this.parents.entrySet()) {
            map.put((Object)e.getKey(), (Object)ImmutableList.copyOf((Collection)e.getValue()));
        }
        return map.build();
    }

    @Override
    public ImmutableList<LPSubjectReference> getParents(ImmutableContextSet contexts) {
        return ImmutableList.copyOf((Collection)this.parents.getOrDefault(contexts, (Set<LPSubjectReference>)ImmutableSet.of()));
    }

    public Set<LPSubjectReference> resolveParents(QueryOptions filter) {
        TreeMap<ImmutableContextSet, Set<LPSubjectReference>> sorted = new TreeMap<ImmutableContextSet, Set<LPSubjectReference>>(ContextSetComparator.reverse());
        for (Map.Entry<ImmutableContextSet, Set<LPSubjectReference>> entry : this.parents.entrySet()) {
            if (!filter.satisfies(entry.getKey())) continue;
            sorted.put(entry.getKey(), entry.getValue());
        }
        LinkedHashSet<LPSubjectReference> result = new LinkedHashSet<LPSubjectReference>();
        for (Set set : sorted.values()) {
            result.addAll(set);
        }
        return result;
    }

    @Override
    public CompletableFuture<Boolean> addParent(ImmutableContextSet contexts, LPSubjectReference parent) {
        Set set = this.parents.computeIfAbsent(contexts, c -> ConcurrentHashMap.newKeySet());
        boolean b = set.add(parent);
        if (b) {
            this.service.invalidateAllCaches();
        }
        return CompletableFuture.completedFuture(b);
    }

    @Override
    public CompletableFuture<Boolean> removeParent(ImmutableContextSet contexts, LPSubjectReference parent) {
        boolean b;
        Set<LPSubjectReference> set = this.parents.get(contexts);
        boolean bl = b = set != null && set.remove(parent);
        if (b) {
            this.service.invalidateAllCaches();
        }
        return CompletableFuture.completedFuture(b);
    }

    @Override
    public CompletableFuture<Boolean> clearParents() {
        if (this.parents.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        this.parents.clear();
        this.service.invalidateAllCaches();
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> clearParents(ImmutableContextSet contexts) {
        Set<LPSubjectReference> set = this.parents.get(contexts);
        if (set == null) {
            return CompletableFuture.completedFuture(false);
        }
        this.parents.remove(contexts);
        this.service.invalidateAllCaches();
        return CompletableFuture.completedFuture(!set.isEmpty());
    }

    @Override
    public ImmutableMap<ImmutableContextSet, ImmutableMap<String, String>> getAllOptions() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<ImmutableContextSet, Map<String, String>> e : this.options.entrySet()) {
            map.put((Object)e.getKey(), (Object)ImmutableMap.copyOf(e.getValue()));
        }
        return map.build();
    }

    @Override
    public ImmutableMap<String, String> getOptions(ImmutableContextSet contexts) {
        return ImmutableMap.copyOf(this.options.getOrDefault(contexts, (Map<String, String>)ImmutableMap.of()));
    }

    public Map<String, String> resolveOptions(QueryOptions filter) {
        TreeMap<ImmutableContextSet, Map<String, String>> sorted = new TreeMap<ImmutableContextSet, Map<String, String>>(ContextSetComparator.reverse());
        for (Map.Entry<ImmutableContextSet, Map<String, String>> entry : this.options.entrySet()) {
            if (!filter.satisfies(entry.getKey())) continue;
            sorted.put(entry.getKey(), entry.getValue());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map map : sorted.values()) {
            for (Map.Entry e : map.entrySet()) {
                result.putIfAbsent((String)e.getKey(), (String)e.getValue());
            }
        }
        return result;
    }

    @Override
    public CompletableFuture<Boolean> setOption(ImmutableContextSet contexts, String key, String value) {
        boolean b;
        Map options = this.options.computeIfAbsent(contexts, c -> new ConcurrentHashMap());
        boolean bl = b = !CalculatedSubjectData.stringEquals(options.put(key.toLowerCase(), value), value);
        if (b) {
            this.service.invalidateAllCaches();
        }
        return CompletableFuture.completedFuture(b);
    }

    @Override
    public CompletableFuture<Boolean> unsetOption(ImmutableContextSet contexts, String key) {
        boolean b;
        Map<String, String> options = this.options.get(contexts);
        boolean bl = b = options != null && options.remove(key.toLowerCase()) != null;
        if (b) {
            this.service.invalidateAllCaches();
        }
        return CompletableFuture.completedFuture(b);
    }

    @Override
    public CompletableFuture<Boolean> clearOptions() {
        if (this.options.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        this.options.clear();
        this.service.invalidateAllCaches();
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> clearOptions(ImmutableContextSet contexts) {
        Map<String, String> map = this.options.get(contexts);
        if (map == null) {
            return CompletableFuture.completedFuture(false);
        }
        this.options.remove(contexts);
        this.service.invalidateAllCaches();
        return CompletableFuture.completedFuture(!map.isEmpty());
    }

    private static boolean stringEquals(String a, String b) {
        return a == null && b == null || a != null && b != null && a.equalsIgnoreCase(b);
    }
}

