/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.model.persisted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.common.context.ContextSetComparator;
import me.lucko.luckperms.common.context.ContextSetJsonSerializer;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import me.lucko.luckperms.sponge.service.model.calculated.CalculatedSubjectData;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;

public class SubjectDataContainer {
    private final Map<ImmutableContextSet, Map<String, Boolean>> permissions;
    private final Map<ImmutableContextSet, Map<String, String>> options;
    private final Map<ImmutableContextSet, List<LPSubjectReference>> parents;

    public static SubjectDataContainer copyOf(LPSubjectData subjectData) {
        return new SubjectDataContainer((Map<ImmutableContextSet, ? extends Map<String, Boolean>>)subjectData.getAllPermissions(), (Map<ImmutableContextSet, ? extends Map<String, String>>)subjectData.getAllOptions(), (Map<ImmutableContextSet, ? extends List<LPSubjectReference>>)subjectData.getAllParents());
    }

    public static SubjectDataContainer deserialize(LPPermissionService service, JsonObject root) {
        return new SubjectDataContainer(service, root);
    }

    private SubjectDataContainer(Map<ImmutableContextSet, ? extends Map<String, Boolean>> permissions, Map<ImmutableContextSet, ? extends Map<String, String>> options, Map<ImmutableContextSet, ? extends List<LPSubjectReference>> parents) {
        ImmutableMap.Builder permissionsBuilder = ImmutableMap.builder();
        for (Map.Entry<ImmutableContextSet, ? extends Map<String, Boolean>> entry : permissions.entrySet()) {
            permissionsBuilder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
        }
        this.permissions = permissionsBuilder.build();
        ImmutableMap.Builder optionsBuilder = ImmutableMap.builder();
        for (Map.Entry<ImmutableContextSet, ? extends Map<String, String>> entry : options.entrySet()) {
            optionsBuilder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
        }
        this.options = optionsBuilder.build();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ImmutableContextSet, ? extends List<LPSubjectReference>> e : parents.entrySet()) {
            builder.put((Object)e.getKey(), (Object)ImmutableList.copyOf((Collection)e.getValue()));
        }
        this.parents = builder.build();
    }

    private static JsonArray getArray(JsonObject root, String key) {
        JsonElement element = root.get(key);
        if (element == null) {
            return new JsonArray();
        }
        Preconditions.checkArgument((boolean)(element instanceof JsonArray));
        return (JsonArray)element;
    }

    private SubjectDataContainer(LPPermissionService service, JsonObject root) {
        JsonArray permissions = SubjectDataContainer.getArray(root, "permissions");
        JsonArray options = SubjectDataContainer.getArray(root, "options");
        JsonArray parents = SubjectDataContainer.getArray(root, "parents");
        ImmutableMap.Builder permissionsBuilder = ImmutableMap.builder();
        for (Object e : permissions) {
            JsonObject section;
            if (!e.isJsonObject() || !(section = e.getAsJsonObject()).get("context").isJsonObject() || !section.get("data").isJsonObject()) continue;
            JsonObject context = section.get("context").getAsJsonObject();
            JsonObject data = section.get("data").getAsJsonObject();
            ImmutableContextSet contextSet = ContextSetJsonSerializer.deserializeContextSet((JsonElement)context).immutableCopy();
            ImmutableMap.Builder perms = ImmutableMap.builder();
            for (Object perm : data.entrySet()) {
                perms.put(perm.getKey(), (Object)((JsonElement)perm.getValue()).getAsBoolean());
            }
            permissionsBuilder.put((Object)contextSet, (Object)perms.build());
        }
        this.permissions = permissionsBuilder.build();
        ImmutableMap.Builder optionsBuilder = ImmutableMap.builder();
        for (JsonElement e : options) {
            JsonObject section;
            if (!e.isJsonObject() || !(section = e.getAsJsonObject()).get("context").isJsonObject() || !section.get("data").isJsonObject()) continue;
            JsonObject context = section.get("context").getAsJsonObject();
            JsonObject data = section.get("data").getAsJsonObject();
            ImmutableContextSet contextSet = ContextSetJsonSerializer.deserializeContextSet((JsonElement)context).immutableCopy();
            ImmutableMap.Builder opts = ImmutableMap.builder();
            for (Map.Entry opt : data.entrySet()) {
                opts.put(opt.getKey(), (Object)((JsonElement)opt.getValue()).getAsString());
            }
            optionsBuilder.put((Object)contextSet, (Object)opts.build());
        }
        this.options = optionsBuilder.build();
        ImmutableMap.Builder parentsBuilder = ImmutableMap.builder();
        for (JsonElement e : parents) {
            JsonObject section;
            if (!e.isJsonObject() || !(section = e.getAsJsonObject()).get("context").isJsonObject() || !section.get("data").isJsonArray()) continue;
            JsonObject context = section.get("context").getAsJsonObject();
            JsonArray data = section.get("data").getAsJsonArray();
            ImmutableContextSet contextSet = ContextSetJsonSerializer.deserializeContextSet((JsonElement)context).immutableCopy();
            ImmutableList.Builder pars = ImmutableList.builder();
            for (JsonElement p : data) {
                if (!p.isJsonObject()) continue;
                JsonObject parent = p.getAsJsonObject();
                String collection = parent.get("collection").getAsString();
                String subject = parent.get("subject").getAsString();
                pars.add((Object)service.getReferenceFactory().obtain(collection, subject));
            }
            parentsBuilder.put((Object)contextSet, (Object)pars.build());
        }
        this.parents = parentsBuilder.build();
    }

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonArray permissions = new JsonArray();
        for (Map.Entry<ImmutableContextSet, Map<String, Boolean>> e : SubjectDataContainer.sortContextMap(this.permissions)) {
            if (e.getValue().isEmpty()) continue;
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("context", (JsonElement)ContextSetJsonSerializer.serializeContextSet((ContextSet)e.getKey()));
            JsonObject data = new JsonObject();
            ArrayList perms = new ArrayList(((Map)e.getValue()).entrySet());
            perms.sort(Map.Entry.comparingByKey());
            for (Map.Entry entry : perms) {
                data.addProperty((String)entry.getKey(), (Boolean)entry.getValue());
            }
            jsonObject.add("data", (JsonElement)data);
            permissions.add((JsonElement)jsonObject);
        }
        root.add("permissions", (JsonElement)permissions);
        JsonArray options = new JsonArray();
        for (Map.Entry entry : SubjectDataContainer.sortContextMap(this.options)) {
            if (((Map)entry.getValue()).isEmpty()) continue;
            JsonObject section = new JsonObject();
            section.add("context", (JsonElement)ContextSetJsonSerializer.serializeContextSet((ContextSet)entry.getKey()));
            JsonObject data = new JsonObject();
            ArrayList opts = new ArrayList(((Map)entry.getValue()).entrySet());
            opts.sort(Map.Entry.comparingByKey());
            for (Map.Entry entry2 : opts) {
                data.addProperty((String)entry2.getKey(), (String)entry2.getValue());
            }
            section.add("data", (JsonElement)data);
            options.add((JsonElement)section);
        }
        root.add("options", (JsonElement)options);
        JsonArray parents = new JsonArray();
        for (Map.Entry<ImmutableContextSet, List<LPSubjectReference>> e : SubjectDataContainer.sortContextMap(this.parents)) {
            if (e.getValue().isEmpty()) continue;
            JsonObject section = new JsonObject();
            section.add("context", (JsonElement)ContextSetJsonSerializer.serializeContextSet(e.getKey()));
            JsonArray data = new JsonArray();
            for (LPSubjectReference lPSubjectReference : e.getValue()) {
                JsonObject parent = new JsonObject();
                parent.addProperty("collection", lPSubjectReference.getCollectionIdentifier());
                parent.addProperty("subject", lPSubjectReference.getSubjectIdentifier());
                data.add((JsonElement)parent);
            }
            section.add("data", (JsonElement)data);
            options.add((JsonElement)section);
        }
        root.add("parents", (JsonElement)parents);
        return root;
    }

    public void applyToData(CalculatedSubjectData subjectData) {
        subjectData.replacePermissions(this.permissions);
        subjectData.replaceOptions(this.options);
        subjectData.replaceParents(this.parents);
    }

    private static <T> List<Map.Entry<ImmutableContextSet, T>> sortContextMap(Map<ImmutableContextSet, T> map) {
        ArrayList<Map.Entry<ImmutableContextSet, T>> entries = new ArrayList<Map.Entry<ImmutableContextSet, T>>(map.entrySet());
        entries.sort((o1, o2) -> ContextSetComparator.reverse().compare((ImmutableContextSet)o1.getKey(), (ImmutableContextSet)o2.getKey()));
        return entries;
    }
}

