/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.model.persisted;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.common.util.MoreFiles;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.persisted.PersistedSubject;
import me.lucko.luckperms.sponge.service.model.persisted.SubjectDataContainer;

public class SubjectStorage {
    private final LPPermissionService service;
    private final Path container;

    public SubjectStorage(LPPermissionService service, Path container) {
        this.service = service;
        this.container = container;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getSavedCollections() {
        if (!Files.exists(this.container, new LinkOption[0])) {
            return ImmutableSet.of();
        }
        try (Stream<Path> s = Files.list(this.container);){
            Set set = (Set)s.filter(p -> Files.isDirectory(p, new LinkOption[0])).map(p -> p.getFileName().toString()).collect(ImmutableCollectors.toSet());
            return set;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ImmutableSet.of();
        }
    }

    private Path resolveFile(String collectionIdentifier, String subjectIdentifier) {
        Path collection = this.container.resolve(collectionIdentifier);
        try {
            MoreFiles.createDirectoriesIfNotExists(collection);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return collection.resolve(subjectIdentifier + ".json");
    }

    public void saveToFile(PersistedSubject subject) throws IOException {
        Path subjectFile = this.resolveFile(subject.getParentCollection().getIdentifier(), subject.getIdentifier());
        this.saveToFile(SubjectDataContainer.copyOf(subject.getSubjectData()), subjectFile);
    }

    public void saveToFile(SubjectDataContainer container, Path file) throws IOException {
        MoreFiles.createDirectoriesIfNotExists(file.getParent());
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            GsonProvider.prettyPrinting().toJson((JsonElement)container.serialize(), (Appendable)writer);
            writer.flush();
        }
    }

    public Map<String, SubjectDataContainer> loadAllFromFile(String collectionIdentifier) {
        Path collection = this.container.resolve(collectionIdentifier);
        if (!Files.exists(collection, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        HashMap<String, SubjectDataContainer> holders = new HashMap<String, SubjectDataContainer>();
        try (Stream<Path> s = Files.list(collection);){
            s.filter(p -> p.getFileName().toString().endsWith(".json")).forEach(subjectFile -> {
                try {
                    LoadedSubject sub = this.loadFromFile((Path)subjectFile);
                    if (sub != null) {
                        holders.put(sub.identifier, sub.data);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return holders;
    }

    public LoadedSubject loadFromFile(String collectionIdentifier, String subjectIdentifier) throws IOException {
        Path collection = this.container.resolve(collectionIdentifier);
        if (!Files.exists(collection, new LinkOption[0])) {
            return null;
        }
        Path subject = collection.resolve(subjectIdentifier + ".json");
        return new LoadedSubject(subjectIdentifier, this.loadFromFile(subject).data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LoadedSubject loadFromFile(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        String fileName = file.getFileName().toString();
        String subjectName = fileName.substring(0, fileName.length() - ".json".length());
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            JsonObject data = (JsonObject)GsonProvider.prettyPrinting().fromJson((Reader)reader, JsonObject.class);
            SubjectDataContainer model = SubjectDataContainer.deserialize(this.service, data);
            LoadedSubject loadedSubject = new LoadedSubject(subjectName, model);
            return loadedSubject;
        }
        catch (Exception e) {
            throw new IOException("Exception occurred whilst loading from " + file.toString(), e);
        }
    }

    private static final class LoadedSubject {
        private final String identifier;
        private final SubjectDataContainer data;

        private LoadedSubject(String identifier, SubjectDataContainer data) {
            this.identifier = identifier;
            this.data = data;
        }
    }
}

