/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.proxy.api6;

import java.util.Map;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.sponge.service.model.LPPermissionDescription;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.ProxiedServiceObject;
import me.lucko.luckperms.sponge.service.proxy.api6.SubjectProxy;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;

public final class PermissionDescriptionProxy
implements PermissionDescription,
ProxiedServiceObject {
    private final LPPermissionService service;
    private final LPPermissionDescription handle;

    public PermissionDescriptionProxy(LPPermissionService service, LPPermissionDescription handle) {
        this.service = service;
        this.handle = handle;
    }

    public @NonNull String getId() {
        return this.handle.getId();
    }

    public @NonNull Text getDescription() {
        return this.handle.getDescription().orElse(Text.EMPTY);
    }

    public @NonNull PluginContainer getOwner() {
        return this.handle.getOwner().orElseGet(() -> (PluginContainer)Sponge.getGame().getPluginManager().fromInstance((Object)this.service.getPlugin()).orElseThrow(() -> new RuntimeException("Unable to get LuckPerms instance.")));
    }

    public @NonNull Map<Subject, Boolean> getAssignedSubjects(@NonNull String s) {
        return (Map)this.handle.getAssignedSubjects(s).entrySet().stream().collect(ImmutableCollectors.toMap(e -> new SubjectProxy(this.service, ((LPSubject)e.getKey()).toReference()), Map.Entry::getValue));
    }

    public boolean equals(Object o) {
        return o == this || o instanceof PermissionDescriptionProxy && this.handle.equals(((PermissionDescriptionProxy)o).handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return "luckperms.api6.PermissionDescriptionProxy(handle=" + this.handle + ")";
    }
}

