/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.model.group;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.node.HeldNode;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.matcher.NodeMatcher;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface GroupManager {
    public @NonNull CompletableFuture<Group> createAndLoadGroup(@NonNull String var1);

    public @NonNull CompletableFuture<Optional<Group>> loadGroup(@NonNull String var1);

    public @NonNull CompletableFuture<Void> saveGroup(@NonNull Group var1);

    public @NonNull CompletableFuture<Void> deleteGroup(@NonNull Group var1);

    default public @NonNull CompletableFuture<Void> modifyGroup(@NonNull String name, @NonNull Consumer<? super Group> action) {
        return ((CompletableFuture)this.createAndLoadGroup(name).thenApplyAsync(group -> {
            action.accept((Group)group);
            return group;
        })).thenCompose(this::saveGroup);
    }

    public @NonNull CompletableFuture<Void> loadAllGroups();

    public <T extends Node> @NonNull CompletableFuture<Map<String, Collection<T>>> searchAll(@NonNull NodeMatcher<? extends T> var1);

    @Deprecated
    public @NonNull CompletableFuture<List<HeldNode<String>>> getWithPermission(@NonNull String var1);

    public @Nullable Group getGroup(@NonNull String var1);

    public @NonNull Set<Group> getLoadedGroups();

    public boolean isLoaded(@NonNull String var1);
}

