/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.node.matcher;

import java.util.function.Predicate;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.MetaNode;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface NodeMatcher<T extends Node>
extends Predicate<Node> {
    public static @NonNull NodeMatcher<Node> key(@NonNull String key) {
        return LuckPermsProvider.get().getNodeMatcherFactory().key(key);
    }

    public static <T extends Node> @NonNull NodeMatcher<T> key(@NonNull T node) {
        return LuckPermsProvider.get().getNodeMatcherFactory().key(node);
    }

    public static @NonNull NodeMatcher<Node> keyStartsWith(@NonNull String startingWith) {
        return LuckPermsProvider.get().getNodeMatcherFactory().keyStartsWith(startingWith);
    }

    public static <T extends Node> @NonNull NodeMatcher<T> equals(@NonNull T other, @NonNull NodeEqualityPredicate equalityPredicate) {
        return LuckPermsProvider.get().getNodeMatcherFactory().equals(other, equalityPredicate);
    }

    public static @NonNull NodeMatcher<MetaNode> metaKey(@NonNull String metaKey) {
        return LuckPermsProvider.get().getNodeMatcherFactory().metaKey(metaKey);
    }

    public static @NonNull NodeMatcher<MetaNode> metaKey(@NonNull MetaNode metaNode) {
        return NodeMatcher.metaKey(metaNode.getMetaKey());
    }

    public static <T extends Node> @NonNull NodeMatcher<T> type(NodeType<? extends T> type) {
        return LuckPermsProvider.get().getNodeMatcherFactory().type(type);
    }

    @Override
    public boolean test(@NonNull Node var1);
}

