/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb;

import java.io.IOException;
import java.io.OutputStream;
import me.lucko.luckperms.lib.mariadb.MariaDbBlob;

class BlobOutputStream
extends OutputStream {
    private final MariaDbBlob blob;
    private int pos;

    public BlobOutputStream(MariaDbBlob blob, int pos) {
        this.blob = blob;
        this.pos = pos;
    }

    @Override
    public void write(int bit) throws IOException {
        if (this.pos >= this.blob.length) {
            byte[] tmp = new byte[2 * this.blob.length + 1];
            System.arraycopy(this.blob.data, this.blob.offset, tmp, 0, this.blob.length);
            this.blob.data = tmp;
            this.pos -= this.blob.offset;
            this.blob.offset = 0;
            ++this.blob.length;
        }
        this.blob.data[this.pos] = (byte)bit;
        ++this.pos;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (off < 0) {
            throw new IOException("Invalid offset " + off);
        }
        int realLen = Math.min(buf.length - off, len);
        if (this.pos + realLen >= this.blob.length) {
            int newLen = 2 * this.blob.length + realLen;
            byte[] tmp = new byte[newLen];
            System.arraycopy(this.blob.data, this.blob.offset, tmp, 0, this.blob.length);
            this.blob.data = tmp;
            this.pos -= this.blob.offset;
            this.blob.offset = 0;
            this.blob.length = this.pos + realLen;
        }
        System.arraycopy(buf, off, this.blob.data, this.pos, realLen);
        this.pos += realLen;
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }
}

