/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb.credential.aws;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.luckperms.lib.mariadb.HostAddress;
import me.lucko.luckperms.lib.mariadb.credential.Credential;
import me.lucko.luckperms.lib.mariadb.credential.CredentialPlugin;
import me.lucko.luckperms.lib.mariadb.credential.aws.AwsCredentialGenerator;
import me.lucko.luckperms.lib.mariadb.util.Options;

public class AwsIamCredentialPlugin
implements CredentialPlugin {
    private static final int TOKEN_TTL = 10;
    private static Map<KeyCache, IdentityExpire> cache = new ConcurrentHashMap<KeyCache, IdentityExpire>();
    private AwsCredentialGenerator generator;
    private KeyCache key;

    @Override
    public String type() {
        return "AWS-IAM";
    }

    @Override
    public String name() {
        return "AWS IAM Authentication plugin";
    }

    @Override
    public boolean mustUseSsl() {
        return true;
    }

    @Override
    public CredentialPlugin initialize(Options options, String userName, HostAddress hostAddress) throws SQLException {
        try {
            Class.forName("com.amazonaws.auth.BasicAWSCredentials");
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException("Identity plugin 'AWS-IAM' is used without having AWS SDK in classpath. Please add 'com.amazonaws:aws-java-sdk-rds' to classpath");
        }
        this.generator = new AwsCredentialGenerator(options.nonMappedOptions, userName, hostAddress);
        this.key = new KeyCache(options, userName, hostAddress);
        return this;
    }

    @Override
    public Credential get() {
        IdentityExpire val = cache.get(this.key);
        if (val != null && val.isValid()) {
            return val.getCredential();
        }
        Credential credential = this.generator.getToken();
        cache.put(this.key, new IdentityExpire(credential));
        return credential;
    }

    private class KeyCache {
        private Options options;
        private String userName;
        private HostAddress hostAddress;

        public KeyCache(Options options, String userName, HostAddress hostAddress) {
            this.options = options;
            this.userName = userName;
            this.hostAddress = hostAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyCache keyCache = (KeyCache)o;
            return this.options.equals(keyCache.options) && Objects.equals(this.userName, keyCache.userName) && this.hostAddress.equals(keyCache.hostAddress);
        }

        public int hashCode() {
            return Objects.hash(this.options, this.userName, this.hostAddress);
        }
    }

    private class IdentityExpire {
        private LocalDateTime expiration;
        private Credential credential;

        public IdentityExpire(Credential credential) {
            this.credential = credential;
            this.expiration = LocalDateTime.now().plusMinutes(10L);
        }

        public boolean isValid() {
            return this.expiration.isAfter(LocalDateTime.now());
        }

        public Credential getCredential() {
            return this.credential;
        }
    }
}

