/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb.credential.env;

import me.lucko.luckperms.lib.mariadb.HostAddress;
import me.lucko.luckperms.lib.mariadb.credential.Credential;
import me.lucko.luckperms.lib.mariadb.credential.CredentialPlugin;
import me.lucko.luckperms.lib.mariadb.util.Options;

public class EnvCredentialPlugin
implements CredentialPlugin {
    private Options options;
    private String userName;

    @Override
    public String type() {
        return "ENV";
    }

    @Override
    public String name() {
        return "Environment password";
    }

    @Override
    public CredentialPlugin initialize(Options options, String userName, HostAddress hostAddress) {
        this.options = options;
        this.userName = userName;
        return this;
    }

    @Override
    public Credential get() {
        String userKey = this.options.nonMappedOptions.getProperty("userKey");
        String pwdKey = this.options.nonMappedOptions.getProperty("pwdKey");
        String envUser = System.getenv(userKey != null ? userKey : "MARIADB_USER");
        return new Credential(envUser == null ? this.userName : envUser, System.getenv(pwdKey != null ? pwdKey : "MARIADB_PWD"));
    }
}

