/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.mariadb.credential.system;

import me.lucko.luckperms.lib.mariadb.HostAddress;
import me.lucko.luckperms.lib.mariadb.credential.Credential;
import me.lucko.luckperms.lib.mariadb.credential.CredentialPlugin;
import me.lucko.luckperms.lib.mariadb.util.Options;

public class PropertiesCredentialPlugin
implements CredentialPlugin {
    private Options options;
    private String userName;

    @Override
    public String type() {
        return "PROPERTY";
    }

    @Override
    public String name() {
        return "Environment password";
    }

    @Override
    public CredentialPlugin initialize(Options options, String userName, HostAddress hostAddress) {
        this.options = options;
        this.userName = userName;
        return this;
    }

    @Override
    public Credential get() {
        String userKey = this.options.nonMappedOptions.getProperty("userKey");
        String pwdKey = this.options.nonMappedOptions.getProperty("pwdKey");
        String propUser = System.getProperty(userKey != null ? userKey : "mariadb.user");
        return new Credential(propUser == null ? this.userName : propUser, System.getProperty(pwdKey != null ? pwdKey : "mariadb.pwd"));
    }
}

